/* melon.h -- main header file 
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

#include <errno.h>
#include <sys/types.h>
#include "def.h"

#ifndef MELON_H
#define MELON_H

#define MAX_MBOX	50
#define MELON_VERSION	"1.6"

/* File types to be checked */
#define MELON_FILE_TYPE	0
#define MELON_MBOX_TYPE	1
#define MELON_MDIR_TYPE	2

/* data types and structures */
struct widgets_data {
	GtkWidget	*window;
	GtkWidget	*pixmap;
	GdkPixmap	*gdk_pixmap;
	GdkPixmap	*new_gdk_pixmap;
	GdkBitmap	*mask1;
	GdkBitmap	*mask2;
	int		xwindow;
	int		ywindow;
	int		unread_msg[MAX_MBOX];
	time_t		m_time[MAX_MBOX];
	off_t		size[MAX_MBOX];
	int		beep[MAX_MBOX];
};

struct pixmaps_data {
	char pix_name[MAX_PLEN];
	char no_mail_pix[MAX_PLEN];
	char new_mail_pix[MAX_PLEN];
};

struct config_data {
	char no_mail_pix[MAX_PLEN];
	char new_mail_pix[MAX_PLEN];
	char beep_file[MAX_PLEN];
	char beep_device[MAX_PLEN];
	int beep_mode;
	int interval;
	char xposition[16];
	char yposition[16];
	int save_status;
	char mbox[MAX_MBOX][MAX_PLEN];
	int is_a_mbox[MAX_MBOX];
	char mailer[MAX_PLEN];
	char color_style[16];
	GdkColor bgcolor;
	GdkColor fgcolor;
	GdkColor abgcolor;
	GdkColor afgcolor;
};

#include "globals.h"

/* function prototypes */
int melon_error(const char *fmt, ...);
gint check_mbox (gpointer data);
void config_update (void);
gint see_mail (GtkWidget *widget, char *mbox);
void play_beep(void);
void pop_menu(GdkEventButton *event_button);
void active_mbox_menu(GdkEventButton *event_button);
int none_active_mbox(void);
int pixmap_exist (char *path);
void dialog_message (char *message);
void reset_mbox_status (char *mbox);
void set_style(void);
void set_melon_def_colors (void);
gint close_application( GtkWidget *widget,
	GdkEvent  *event,
	gpointer   data );

#endif
