/* 
 * $Id: ctklabel.h,v 1.10 2000/07/07 00:27:32 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTKLABEL_H__
# define __CTKLABEL_H__ 

extern gboolean ctk_label_wrap_hack_report_vertible;

typedef struct CtkLabel_S 
{
      CtkMisc misc;

      gchar*  text;
      gchar** text_split;

      gboolean wrap;
      gboolean first;
} CtkLabel;

CtkWidget* ctk_label_new(const gchar* text);
CtkWidget* ctk_label_newf(const gchar* format, ...);

void ctk_label_set_text(CtkLabel* label, const gchar* text);
void ctk_label_set_line_wrap(CtkLabel* label, gboolean wrap);

#define CTK_LABEL(obj)	CTK_CHECK_CAST((obj),CtkLabel,CtkTypeLabel)

void ctk_label_min_size(CtkWidget* widget);
void ctk_label_real_size(CtkWidget* widget);
void ctk_label_set_justify(CtkLabel *label, CtkJustification jtype);

#define ctk_label_set ctk_label_set_text
#define DEF_WRAP_WIDTH 30
#endif
