/***************************************************************************
 $RCSfile: tutorial1.cpp,v $
                             -------------------
    cvs         : $Id: tutorial1.cpp,v 1.4 2003/04/24 01:43:47 aquamaniac Exp $
    begin       : Sun Nov 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * This is a small tutorial on how to use the basic functions of the
 * libchipcard. It just determines whether an inserted card is a processor
 * or a memory card.
 * This is the most basic type of application using a chipcard, no error
 * checking is performed.
 * This tutorial is intended to show the basics only.
 * After studying this tutorial you should advance to the next one, which
 * will explain all the methods used.
 *
 * Usage:
 *   tutorial1
 */


#include <stdio.h>
#include "chipcard.h"





int main(int argc,char **argv) {
  CTCardTrader *trader;
  CTCard *card;

  trader=new CTCardTrader(false,
			  0,
			  0,
			  CHIPCARD_STATUS_INSERTED,
			  CHIPCARD_STATUS_INSERTED |
			  CHIPCARD_STATUS_LOCKED_BY_OTHER,
			  CHIPCARD_STATUS_INSERTED);

  trader->start();

  fprintf(stderr,"Please insert your card.\n");

  trader->getNext(card, 30);

  fprintf(stderr,"Card inserted, working.\n");

  card->openCard();

  if (card->isProcessorCard())
    printf("The card is a processor card.\n");
  else {
    printf("The card is a memory card (size=%d).\n",
	   card->memorySize());
  }

  card->closeCard();

  trader->stop();

  printf("Bye.\n");
  return 0;
}







