/***************************************************************************
 $RCSfile: readerserver.h,v $
 -------------------
 cvs         : $Id: readerserver.h,v 1.6 2003/04/22 22:59:23 aquamaniac Exp $
 begin       : Sat Jan 11 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#ifndef READERSERVER_H
#define READERSERVER_H "$Id: readerserver.h,v 1.6 2003/04/22 22:59:23 aquamaniac Exp $"

#include <ctcore.h>
#include <ctserver.h>
#include <chameleon/conf.h>


#ifdef __cplusplus
extern "C" {
#endif


/*___________________________________________________________________________
 *AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 *                          Wait-For-Reader-Status
 *YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
 */

typedef struct READERSERVERWAITSTRUCT READERSERVERWAITDATA;
struct READERSERVERWAITSTRUCT {
  READERSERVERWAITDATA *next;
  int msgLayerId;
  int requestId;
  int mustChange;
  char *typeName;
  unsigned int readerFlags;
  unsigned int readerFlagsMask;
  unsigned int readerStatus;
  unsigned int readerStatusMask;
  unsigned int readerDeltaStatus;
};


READERSERVERWAITDATA *ReaderServer__WaitRequest_new();
void ReaderServer_WaitRequest__free(READERSERVERWAITDATA *wr);



/*___________________________________________________________________________
 *AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 *                          Wait-For-Reader-Unlock
 *YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
 */

typedef struct READERSERVEROPENSTRUCT READERSERVEROPENDATA;
struct READERSERVEROPENSTRUCT {
  READERSERVEROPENDATA *next;
  int msgLayerId;
  int requestId;
  int readerId;
  int readerNumber;
  int cardId;
};

READERSERVEROPENDATA *ReaderServer__OpenRequest_new();
void ReaderServer_OpenRequest__free(READERSERVEROPENDATA *wr);





struct READERSERVERDATASTRUCT {
  CTCORETABLE *core;
  int coreClientId;
  READERSERVERWAITDATA *waitRequests;
  READERSERVEROPENDATA *openRequests;
};
typedef struct READERSERVERDATASTRUCT READERSERVERDATA;


READERSERVERDATA *ReaderServer_new();
void ReaderServer_free(READERSERVERDATA *rsd);

ERRORCODE ReaderServer_Init(CTSERVERDATA *sd, CONFIGGROUP *root);
ERRORCODE ReaderServer_Fini(CTSERVERDATA *sd);

/**
 * Adds a reader description.
 * This functions does not take over ownership of this description !
 */
ERRORCODE ReaderServer_AddReader(CTSERVERDATA *sd, CTREADERDESCRIPTION *rd);
ERRORCODE ReaderServer_AllocAllReaders(CTSERVERDATA *sd);
ERRORCODE ReaderServer_CheckWaitResponses(CTSERVERDATA *sd,
					  int mustChange);
ERRORCODE ReaderServer_CheckOpenResponses(CTSERVERDATA *sd,
					  int ignoreLocks);
ERRORCODE ReaderServer_Work(CTSERVERDATA *sd,
			    int timeout,
			    int maxmsg);


#ifdef __cplusplus
}
#endif


#endif

