/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * @author Jeffrey S. Morgan
 *
 * This is the listener interface for receiving mouse button
 * events and mouse enter and leave events.
 * 
 * @see MouseEvent
 */
public interface MouseListener {
	
	/**
	 * A mouse event has been called. Return <code>true</code> if you have
	 * handled the event and so don't want it passed on to other listeners.
	 * Since this is usually the first callback to be received, returning
	 * <code>true</code> will stop common actions, such as a toggle button being
	 * toggled or an item being selected in a tree. 
	 */
	public boolean mouseEvent(MouseEvent event);

}
