/*
 * $Id: lexer.ll,v 1.4 2000/10/25 22:52:05 mborella Exp $
 */

%option yylineno
%option noyywrap
%{
/*
 * Definitions section
 */

#include <stdio.h>
#include <string.h>
#include "clparam.h"
#include "parser.h"
#include "genparse.h"

/*
 * Help with debugging
 */
#ifdef DEBUG
#define return_token(x) { fprintf(stderr,"LEX: Token %s: '%s'\n",#x,yytext); return x; }
#else
#define return_token(x) { return (x); }
#endif

%}

/*
 * More definitions
 */

range1                  ".."
range2                  "..."
char                    [A-Za-z]
first_char              ^[A-Za-z]
digit                   [0-9]
alnum                   [\-a-zA-Z_0-9]+(\.[0-9]+)?
c_var                   [a-zA-Z_][a-zA-Z_0-9]*
file                    [a-zA-Z_][a-zA-Z_0-9/]*[\.a-zA-Z_0-9/]*
whitespace              [ \t\n]
doublequote             [\"]
any  .

%%

{whitespace}            ; /* do nothing on whitespace */

"/*" 			{ /* Ignore C comments */
			  int c1 = 0;
			  int c2 = yyinput();
            
                          for (;;)
                            {
                              if (c2 == EOF) break;
			      if (c1 == '*' && c2 == '/') break;
                              c1 = c2;
                              c2 = yyinput();
                            }
			}

{first_char}		{
                          yylval.c = *yytext;
                          return_token(FIRST_CHAR);
			}

"{"			return_token(OPEN_BRACE);
"}"			return_token(CLOSE_BRACE);
"/"			return_token(SLASH);
"int"			return_token(INT);
"float" 		return_token(FLOAT);
"char"			return_token(CHAR);
"string"		return_token(STRING);
"flag"			return_token(FLAG);
"include"               return_token(INCLUDE);
"invocation"            return_token(INVOCATION);
"<"                     return_token(LT);
">"                     return_token(GT);
"#"                     return_token(POUND);
{doublequote}		return_token(DOUBLEQUOTE);
"mandatory"             return_token(MANDATORY);
"NONE"                  return_token(NONE);

{c_var}			{
                          yylval.str = strdup(yytext);
                          return_token(C_VAR);
			}

{file}			{
                          yylval.str = strdup(yytext);
                          return_token(FILENAME);
			}

{alnum}			{
                          yylval.str = strdup(yytext);
                          return_token(ALNUM);
			}

"["			return_token(BEGIN_RANGE);
"]"			return_token(END_RANGE);
{range1}		return_token(RANGE_SPEC1);
{range2}		return_token(RANGE_SPEC2);
"()"			return_token(FUNC_SPEC);
"\""[^\"]*"\""          { 
                          yylval.str = strdup(yytext+1); 
                          yylval.str[strlen(yylval.str)-1]='\0';
                          return_token(QUOTED);
                        }

{any}			{ /* error */
			  fprintf(stderr,"parser error in line %d ('%s') \n",yylineno,yytext);
			  exit(1);
			}

%%
