/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * 	Module: rsct_mem_info.h
 */

#ifndef _RSCT_MEM_INFO_H_
#define _RSCT_MEM_INFO_H_
#include <ece.h>
#include <plugin.h>
#include <assert.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <ha_gs.h>
#include <glib.h>
#define MAX_NODE_INFO_LENGTH 256

typedef struct RSCT_plugin_info_s { 	
  int     node_count; 	
  ece_nodeid_t*   mynode;   	
  ece_nodeid_t**  nodes;	
} RSCT_plugin_info_t;


//clean up, to be called when an application want to exit
void 			RSCT_mem_cleanup(void);

//initialize, to be called when an appication starts
void 			RSCT_mem_init(void);

//copy the corresponding nodeid into the user-provided buffer
void                    RSCT_mem_nodenum_to_nodeid(ece_nodeid_t* nodeid, 
						  int node_number);
//get cluster id
const char * 	        RSCT_mem_get_clusterid(void);

//get my node id
void  	                RSCT_mem_get_mynode(ece_nodeid_t* nodeid);

//get num of config nodes(including offline and online)
int                     RSCT_mem_get_num_config_nodes();


//similar to RSCT_mem_nodenum_to_nodeid
//return a pointer instead of copying to the user-provided buffer
ece_nodeid_t*           RSCT_mem_map_table_lookup(int i);

//copy all nodes to the provided buffer
//the buffer should have enough space
void  			RSCT_mem_get_all_nodes(ece_nodeid_t *);

/****************plugin operations**************************/

//add plugin infomation
void 			RSCT_plugin_add(const int, 
					const int instance_num,
					const ece_nodeid_t*);

//if the specific plugin is running, return TRUE, else return FALSE
boolean		        RSCT_plugin_is_present(const ece_nodeid_t*,
					       const int);

//get node count on which master plugin is running
const int 	        RSCT_plugin_get_running_master_count(void);


//if at least one node's master plugin is running, return TRUE
//else return FALSE
boolean       	        RSCT_plugin_is_filled(void);

//the following two functions are used
//to iterate over running master plugins
void                    RSCT_plugin_init_walk();
ece_nodeid_t*           RSCT_plugin_get_next_nodeid();

void                    RSCT_plugin_remove(int , int);

/***************************************************************/

int                     RSCT_node_get_membership(ece_event_t*);

void                    RSCT_mem_online_offline_update(ha_gs_membership_t * membership_list,
						      boolean online);

int                     RSCT_mem_get_max_node_number();

boolean                 RSCT_mem_has_quorum();

GSList*                 get_gl_plugin_list();
void                    RSCT_mem_print();
#endif
