#!/usr/bin/env entity

<object>

<object name="test" default-lang="perl" __perl-namespace="ETest">

	<renderer name="entity-namespace-test"
		tag="test"
		lang="perl"
		onrender="test_render"
		ondestroy="test_destroy"
		onparent="test_parent">

		<attrib name="something"
			description="The location of something."
			value_desc="string"
			values="*"
			onset="test_attr_set" />
		
		<perl name="test_attr_set"><![CDATA[
		
		sub print_namespace
		{
			my ($node) = @_;
			
			my $obj = $node->parent ("object");
			my $namespace = $obj->attrib ("__perl-namespace");
			print ("namespace is $namespace\n");
		}
		
		sub test_attr_set
		{
			my ($test_node, $attr, $value) = @_;
			
			print ("In test node, test node is $test_node, $attr => $value\n");
			print_namespace ($test_node);
		}
		]]></perl>
		
		<perl name="test_render"><![CDATA[
		sub test_render
		{
			my $node = shift;

			print "!!!in test_render!!!\n";
			print_namespace ($node);
		}
		]]></perl>
		
		<perl name="test_parent"><![CDATA[
		sub test_parent
		{
			print "in test_parent\n";
		}
		]]></perl>

	</renderer>
</object>

<object name="test" ondelete="entity:exit">
  <test name="foo">
  <perl><![CDATA[
  
  	
  	sub testme
	{
      		my $test = enode ("test.foo");
		some_func ();
      		$test->attrib ("something" => "nothing");
    		some_func ();
	}
    	
	sub some_func
	{
    		print ("in some_func\n");
	}

  ]]></perl>
  </test>
  
  <window ondelete="entity:exit" title="Namespace Test">
    <button label="test" onclick="testme"/>
    <button label="exit" onclick="entity:exit"/>
  </window>
</object>

</object>
