/* $Id: GlobPreDef.c,v 1.1 1996/02/06 13:04:38 cogito Exp $ */
/* Copyright, 1993, AG-Kastens, University Of Paderborn */

#include "GlobPreDef.h"
#include "GlobKind.h"
#include "pdl_gen.h"

#include "ligaconsts.h"
#include <string.h>
#include "idn.h"

int IFid, DEPid, ORDid, unusedsym;

DefTableKey THISKey;
DefTableKey HEADKey;
DefTableKey TAILKey;
DefTableKey SYNTKey;
DefTableKey INHKey;
DefTableKey VOIDKey;
DefTableKey NODEKey;
DefTableKey COORDKey;
DefTableKey INTKey;

DefTableKey GramKey;
DefTableKey unusedkey;

static Environment currenv;

static void PreDef (str, id, key, e)
        char            *str;
        int             *id;
        DefTableKey     *key;
/*
On Entry:
        currenv is an Environment
On Exit:
        The string str is defined in currenv.
        id is its symbol code key is its unique key
*/
{       int     idcode;
        int     idtoken = 4; /* token class is not relevant here */
mkidn(str, strlen (str), &idtoken, &idcode);
(*id) = idcode;
(*key) = DefineIdn (currenv, idcode);
}/* PreDef */

Environment InitPreDef (e) Environment e;
{
currenv = e;

PreDef (TNVOID, &unusedsym, &VOIDKey);
SetKindSet (VOIDKey, SingleIS (TypeDef), SingleIS (TypeDef));

PreDef (TNNODE, &unusedsym, &NODEKey);
SetKindSet (NODEKey, SingleIS (TypeDef), SingleIS (TypeDef));

PreDef (TNINT, &unusedsym, &INTKey);
SetKindSet (INTKey, SingleIS (TypeDef), SingleIS (TypeDef));

PreDef (TNCOORD, &unusedsym, &COORDKey);
SetKindSet (COORDKey, SingleIS (TypeDef), SingleIS (TypeDef));

PreDef ("THIS", &unusedsym, &THISKey);
SetKindSet (THISKey, SingleIS (SymDef), SingleIS (SymDef));

PreDef ("HEAD", &unusedsym, &HEADKey);
SetKindSet (HEADKey, SingleIS (SymDef), SingleIS (SymDef));

PreDef ("TAIL", &unusedsym, &TAILKey);
SetKindSet (TAILKey, SingleIS (SymDef), SingleIS (SymDef));

PreDef ("SYNT", &unusedsym, &SYNTKey);
SetKindSet (SYNTKey, SingleIS (SymDef), SingleIS (SymDef));

PreDef ("INH", &unusedsym, &INHKey);
SetKindSet (INHKey, SingleIS (SymDef), SingleIS (SymDef));

PreDef (IFFCT, &IFid, &unusedkey);
PreDef (ORDERFCT, &ORDid, &unusedkey);

GramKey = NewKey ();
return (e); 
}/* InitPreDef */

int IsPreDefSym (k)
        DefTableKey     k;
{
return ((k == THISKey) || (k == HEADKey) || (k == TAILKey) ||
        (k == VOIDKey) || (k == SYNTKey) || (k == INHKey));
}/* IsPreDefSym */
        
