/* $Id: GlobDef.h,v 1.2 1996/06/14 09:32:40 cogito Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#ifndef GLOBDEF_H
#define GLOBDEF_H

#include "args.h"
#include "envmod.h"
#include "err.h"

/*	values of ddl property DefKind
*/
#define unDef		0
#define SymDef		1
#define RuleDef		2
#define TypeDef		3
#define MultDef		4
 
/*	identifier codes of predefined LIDO functions,
	which are checked by the frontend
*/
extern int IFid, DEPid, ORDid, PRAGMAid;

/*	keys for predefined chain symbols
*/
extern DefTableKey ROOTCLASSKey;
extern DefTableKey GramKey;
extern DefTableKey THISKey;
extern DefTableKey HEADKey;
extern DefTableKey TAILKey;
extern DefTableKey VOIDKey;
extern DefTableKey SYNTKey;
extern DefTableKey INHKey;

extern int IsPreDefSym FEARGS(( DefTableKey k ));

extern DefTableKey Declare FEARGS(( Environment scope, int id,
				  int kind, Environment attrscope,
				  POSITION *pos ));
/* On Exit:
	scope has an entry for id, its key is the result
	of the call.
	If the entry is new, its kind is set, otherwise
	it is checked and possibly set to MultDef.
	For SymDef and RuleDef the attribute scope 
	other properties are initialized.
*/


extern Environment EnvPreDefs FEARGS(( Environment attrscope ));
/* On Exit:
	A fresh environment is made and returned.
	The entries for the predefined types are made.
	The identifiers IFid, DEPid, ORDid are coded.
*/

extern void CheckChainSym FEARGS (( DefTableKey symkey, int defocc,
				  POSITION *coord ));

#endif

