/* Distributed Checksum Clearinghouse
 *
 * convert an ID to binary
 *
 * Copyright (c) 2005 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.74-1.12 $Revision$
 */

#include "dcc_defs.h"
#include "dcc_xhdr.h"


/* get client or server-ID */
DCC_CLNT_ID				/* ID or DCC_ID_INVALID */
dcc_get_id(DCC_EMSG emsg, const char *id_str,
	   const char *fnm, int lineno)
{
	char *p;
	unsigned long id;

	id_str += strspn(id_str, DCC_WHITESPACE);
	id = strtoul(id_str, &p, 10);
	if (*p != '\0'
	    || (id != DCC_ID_ANON
		&& (id < DCC_SRVR_ID_MIN || id > DCC_CLNT_ID_MAX))) {
		if (!strcasecmp(id_str, DCC_XHDR_ID_ANON))
			return DCC_ID_ANON;

		dcc_pemsg(EX_DATAERR, emsg, "invalid ID \"%s\"%s",
			  id_str, fnm_lineno(fnm, lineno));
		return DCC_ID_INVALID;
	}

	return id;
}



/* get server-ID */
const char *				/* rest of string */
dcc_get_srvr_id(DCC_EMSG emsg,
		DCC_SRVR_ID *result,	/* ID or DCC_ID_INVALID */
		const char *id_str, const char *dlims,
		const char *fnm, int lineno)
{
	char *p;
	unsigned long id;

	if (!dlims)
		dlims = "";
	id = strtoul(id_str, &p, 10);
	if (p == id_str
	    || (*p && !strchr(dlims, *p))
	    || (id < DCC_SRVR_ID_MIN || id > DCC_SRVR_ID_MAX)) {
		dcc_pemsg(EX_DATAERR, emsg, "invalid server-ID \"%s\"%s",
			  id_str, fnm_lineno(fnm, lineno));
		*result = DCC_ID_INVALID;
		return 0;
	}

	*result = id;
	return p;
}
