#ifndef _TCPIP_MOD_H
#define _TCPIP_MOD_H
#include <time.h>

typedef struct
  {
    unsigned char vh;
    unsigned char stype;
    unsigned short length;
    unsigned short ident;
    unsigned short frag;
    unsigned char ttl;
    unsigned char protocol;
    unsigned short cksum;
    struct in_addr sip;
    struct in_addr dip;
  }
iprec;

typedef struct
  {
    unsigned short sport;
    unsigned short dport;
    unsigned int seqnum;
    unsigned int acknum;
    unsigned char txoff;
    unsigned char flags;
    unsigned short window;
    unsigned short cksum;
    unsigned short urgentptr;
  }
tcprec;

typedef struct
  {
    struct in_addr sip;
    struct in_addr dip;
    unsigned char zero;
    unsigned char proto;
    unsigned short tcplen;
  }
tcpsrec;

typedef struct
  {
    unsigned char type;
    unsigned char code;
    unsigned short cksum;
    unsigned int zero;
    iprec ip;
    unsigned short sport;
    unsigned short dport;
    unsigned int seq;
  }
icmprec;

#define ACK_HACK  1000
#define RANDOM_ACK (ACK_HACK+666)
#define MAXPKT 6

/* 3 seconds of life to reply */
#define LIFE 3

/* Maximum retries before giving up on
   knowing the OS */
#define MAX_RETRIES 2

/* #define's for the TCP flags */
#define YYY 0x80
#define XXX 0x40
#define URG 0x20
#define ACK 0x10
#define PSH 0x08
#define RST 0x04
#define SYN 0x02
#define FIN 0x01

typedef struct
{
  unsigned short set;
  unsigned int seq;
  unsigned int ack;
  unsigned short urg;
  unsigned short win;
  unsigned short flag;
}
OSRES;

/* Structure for a spoofed connection */
typedef struct _spoofrec spoofrec;
struct _spoofrec
  {
    void *data;
    struct sockaddr_in from;
    struct sockaddr_in dest;
    unsigned short sport;
    unsigned short dport;
    unsigned int seq;
    unsigned int ack;
    int retries;
    time_t timeout;
    spoofrec *next;
    OSRES r[MAXPKT + 1];
  };



/* -------------- Prototiping --------------- */
void init_tcpip(void);
int init_pcap(char*);
unsigned short in_cksum (unsigned short *, int);  
void sendip (spoofrec *, char *, short, short *, short *, short);
unsigned short tcpcksum (spoofrec *, char *, short);
short resolve_host (char *, struct sockaddr_in *);
unsigned int gettcp (tcprec *);
void sendtcp (spoofrec *, unsigned short, short); 
struct in_addr getlocalip (unsigned int dest);
char *tcpip_id(void);
extern char *ident_os(unsigned int dest_addr, short dport, OSRES *r);
#endif
