/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  err_symbols_ph.lex
Dates:		  23 Mar 2004
Purpose:	  parse error-symbols alphabet
Grammar being parsed:
	error-symbols       
	(file-name yacco2_error_symbols
	,name-space NS_yacco2_error_symbols)  
	{ 
		1+ terminal definitions where def is
		 terminal-key [AD AB attributes](sym-class C++ name)
		      or
		 terminal-key [AD AB attributes]
		 (sym-class C++ name {C++ directives block} ) 
	}
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |err_symbols_ph| grammar.\fbreak
Dispatcher to parse the Error vocabulary.
@/
fsm	
(fsm-id "err_symbols_ph.lex"
,fsm-filename err_symbols_ph
,fsm-namespace NS_err_symbols_ph
,fsm-class Cerr_symbols_ph{
  user-prefix-declaration
#include "err_symbols_ph_th.h"
#include "o2_externs.h"
using namespace NS_yacco2_terminals;
  ***
  user-declaration
   public: yacco2::AST* cweb_marker__;
  ***
  op
   if(CWEB_MARKER != 0){
     cweb_marker__ = CWEB_MARKER;
     CWEB_MARKER=0;
   }
  ***
  constructor
   cweb_marker__ = 0;
  ***
}
,fsm-version "1.0",fsm-date "23 mar 2004",fsm-debug "false"
,fsm-comments "Dispatcher to parse ``error-symbols'' vocabulary.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rerror_symbols_phrase (){
  -> Rphrase
}

Rphrase (){
  ->  ||| "error-symbols-phrase" 
      NS_err_symbols_ph_th::TH_err_symbols_ph_th {
  op
    ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
  ***
  } 
  ->  ||| |?| NULL {
  op
    ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
  ***
  }
  ->  |?| {
  op
    CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
    sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
    ADD_TOKEN_TO_ERROR_QUEUE(*sym);
  ***
  }
}
}// end of rules
