%% mPICm10.m (figure 10)
%% mathsPIC    circle with arrows
%%-------------------
\documentclass[a4paper]{article}
\usepackage{pictexwd}
\begin{document}
%%---------------------
\beginpicture
paper{units(mm), xrange(5,55), yrange(5,55)}
point(C){30,30}[$\odot$,1.2]   %% center
variable(r){20}                %% radius
drawcircle(C,r)
point(P){C, polar(r,250 deg)}
point(Q){C, polar(r,120 deg)}
point(S){C, polar(r,-30 deg)}
drawpoints(CPQS)
drawlines(PCSQP)
text($P$){P, polar(5,250 deg)}
text($Q$){Q, polar(5,120 deg)}
text($S$){S, polar(5,-30 deg)}
drawAngleArrow{angle(PCS), radius(8) anticlockwise internal}
text($\beta$){C, polar(5,285 deg)}
drawAngleArrow{angle(PQS), radius(12) anticlockwise internal}
text($\alpha$){Q, polar(8,-65 deg)}
show angle(PQS)     % alpha
show angle(PCS)     % beta
\endpicture
%%-------------------
\end{document}




