/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.flowfram;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFramSty;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameData;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameType;
import java.io.IOException;

public class SetFrameContents
extends ControlSequence {
    FlowFramSty sty;
    FlowFrameType type;
    boolean append = false;

    public SetFrameContents(String string, FlowFrameType flowFrameType, FlowFramSty flowFramSty) {
        this(string, flowFrameType, false, flowFramSty);
    }

    public SetFrameContents(String string, FlowFrameType flowFrameType, boolean bl, FlowFramSty flowFramSty) {
        super(string);
        if (flowFrameType == FlowFrameType.FLOW) {
            throw new IllegalArgumentException();
        }
        if (flowFrameType != FlowFrameType.DYNAMIC && bl) {
            throw new IllegalArgumentException();
        }
        this.type = flowFrameType;
        this.sty = flowFramSty;
        this.append = bl;
    }

    @Override
    public Object clone() {
        return new SetFrameContents(this.getName(), this.type, this.append, this.sty);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TeXObject teXObject2;
        FlowFrameData flowFrameData;
        Object object;
        boolean bl = this.popModifier(teXParser, teXObjectList, 42) == 42;
        KeyValList keyValList = TeXParserUtils.popOptKeyValList(teXParser, teXObjectList);
        if (bl) {
            object = this.popLabelString(teXParser, teXObjectList);
            flowFrameData = this.sty.getFrame(this.type, (String)object);
        } else {
            int n = this.popInt(teXParser, teXObjectList);
            flowFrameData = this.sty.getFrame(this.type, n);
        }
        object = null;
        if (keyValList != null) {
            teXObject2 = keyValList.getValue("html");
            if (teXObject2 != null) {
                keyValList.remove("html");
                object = TeXParserUtils.toKeyValList(teXObject2, teXParser);
            }
            if (!keyValList.isEmpty()) {
                teXObject = teXParser.getListener().createStack();
                ((TeXObjectList)teXObject).add(teXParser.getListener().getControlSequence("set" + this.type.toString().toLowerCase() + "frame"));
                ((TeXObjectList)teXObject).add(TeXParserUtils.createGroup(teXParser, new UserNumber(flowFrameData.getID())));
                ((TeXObjectList)teXObject).add(TeXParserUtils.createGroup(teXParser, keyValList));
                TeXParserUtils.process(teXObject, teXParser, teXObjectList);
            }
        }
        teXObject2 = this.popArg(teXParser, teXObjectList);
        if (this.append && flowFrameData.hasContent()) {
            teXObject = flowFrameData.getContent();
            TeXObjectList teXObjectList2 = TeXParserUtils.toList(teXObject, teXParser);
            teXObjectList2.add(teXObject2, true);
            teXObject2 = teXObjectList2;
        }
        flowFrameData.setContent(teXObject2);
        if (object != null) {
            flowFrameData.showContent(teXParser, teXObjectList, (KeyValList)object);
        }
    }
}

