/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import nts.builder.Builder;
import nts.builder.NullBuilder;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.FrozenToken;
import nts.command.LeftBraceToken;
import nts.command.Macro;
import nts.command.MacroBody;
import nts.command.Prim;
import nts.command.RightBraceToken;
import nts.command.Token;
import nts.command.TokenList;
import nts.io.CntxLog;
import nts.io.Log;
import nts.node.BaseNode;
import nts.node.SettingContext;
import nts.node.TypeSetter;
import nts.typo.BuilderPrim;

public class WritePrim
extends BuilderPrim {
    private static final Token FROZEN_END_WRITE = new FrozenToken("endwrite", (Command)new Macro(MacroBody.EMPTY, 2));
    private static final Token[] END_TOKS = new Token[]{RightBraceToken.TOKEN, FROZEN_END_WRITE};
    private static final TokenList END_LIST = new TokenList(END_TOKS);
    private static final NullBuilder NULL_BUILDER = new NullBuilder();
    private transient HashMap table;

    private void initTable() {
        this.table = new HashMap(23);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.initTable();
    }

    public Log get(int num) {
        return (Log)this.table.get(new Integer(num));
    }

    private Log replace(int num, Log output) {
        return this.table.put(new Integer(num), output);
    }

    public void set(int num, Log output) {
        Log old = this.replace(num, output);
        if (old != output && old != null) {
            old.close();
        }
    }

    public void exec(Builder bld, Token src) {
        int num = CommandBase.scanInt();
        TokenList list = Prim.scanTokenList(src, false);
        WritePrim writePrim = this;
        if (writePrim == null) {
            throw null;
        }
        bld.addNode(writePrim.new WriteNode(num, list));
    }

    public boolean immedExec(Token src) {
        int num = CommandBase.scanInt();
        TokenList list = Prim.scanTokenList(src, false);
        this.write(num, list);
        return true;
    }

    protected void write(int num, TokenList list) {
        Log output;
        CommandBase.insertList(END_LIST);
        CommandBase.tracedPushXList(list, "write");
        CommandBase.insertTokenWithoutCleaning(LeftBraceToken.TOKEN);
        Builder.push(NULL_BUILDER);
        list = Prim.scanTokenList(this, true);
        Token tok = CommandBase.nextRawToken();
        if (tok != FROZEN_END_WRITE) {
            CommandBase.error("UnbalancedWrite");
            while ((tok = CommandBase.nextRawToken()) != FROZEN_END_WRITE) {
            }
        }
        Builder.pop();
        CommandBase.getTokStack().dropFinishedPop();
        if (num < 0) {
            Log log = CommandBase.fileLog.startLine();
        } else {
            output = this.get(num);
            if (output == null) {
                output = CommandBase.normLog.startLine();
            }
        }
        output.add(list).endLine();
    }

    public WritePrim(String name) {
        super(name);
        this.initTable();
    }

    protected static abstract class FileNode
    extends BaseNode {
        protected int num;

        public boolean sizeIgnored() {
            return true;
        }

        protected Log addName(Log log, String name) {
            log.addEsc(name);
            return this.num < 0 ? log.add('-') : (this.num > CommandBase.getConfig().getIntParam(Prim.INTP_MAX_FILE_CODE) ? log.add('*') : log.add(this.num));
        }

        public byte beforeWord() {
            return 1;
        }

        public byte afterWord() {
            return 2;
        }

        public abstract void addOn(Log var1, CntxLog var2);

        public FileNode(int num) {
            this.num = num;
        }
    }

    protected class WriteNode
    extends FileNode {
        protected TokenList list;

        public void addOn(Log log, CntxLog cntx) {
            BuilderPrim.addNodeToks(this.addName(log, "write"), this.list);
        }

        public void typeSet(TypeSetter setter, SettingContext sctx) {
            if (sctx.allowIO) {
                WritePrim.this.write(this.num, this.list);
            }
        }

        public WriteNode(int num, TokenList list) {
            super(num);
            this.list = list;
        }
    }
}

