## -*-Tcl-*-
 # ###################################################################
 #  JavaScript mode - tools for editing JavaScript documents
 # 
 #  FILE: "javaScriptMode.tcl"
 #                                    created: 97-02-09 14.00.54 
 #                                last update: 98-08-07 11.09.26 
 #  Author: Johan Linde
 #  E-mail: <jl@theophys.kth.se>
 #     www: <http://bach.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 1.1.1
 # 
 # Copyright 1997, 1998 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

if {[alpha::package vsatisfies ${alpha::version} 7.1b1]} {
alpha::mode JScr 1.1.1 JScrDummy {*.js *.JS} {
	electricBraces electricColon electricSemicolon electricTab } {
} uninstall this-file maintainer {
	"Johan Linde" jl@theophys.kth.se <http://www.theophys.kth.se/~jl/Alpha.html>
} help {file "HTML Help"}
catch {unset JScrmodeVars(elecRBrace)}
catch {unset JScrmodeVars(elecLBrace)}
catch {unset JScrmodeVars(electricSemi)}
catch {unset JScrmodeVars(electricTab)}
catch {unset JScrmodeVars(electricColon)}
} else {
;alpha::mode JScr 1.1.1 JScrDummy {*.js *.JS} {} {
} uninstall this-file maintainer {
	"Johan Linde" jl@theophys.kth.se <http://www.theophys.kth.se/~jl/Alpha.html>
} help {file "HTML Help"}
newPref f elecRBrace 1 JScr
newPref f elecLBrace 1 JScr
newPref f electricSemi 1 JScr
newPref f electricTab 1 JScr
newPref f electricColon 1 JScr
}

newPref v prefixString {//}  JScr
newPref f wordWrap 0 JScr
newPref v funcExpr {^function *([+-a-zA-Z0-9]+)} JScr
newPref v parseExpr {^function *([+-a-zA-Z0-9]+)} JScr
newPref v wordBreak {\w+} JScr
newPref v wordBreakPreface {\W} JScr
newPref v stringColor	green JScr
newPref v commentColor red JScr
newPref v keywordColor blue JScr


regModeKeywords  -e {//} -b {/*} {*/} -c $JScrmodeVars(commentColor) -k $JScrmodeVars(keywordColor)  -s $JScrmodeVars(stringColor) JScr {
	break case continue default delete do export for import in function if else new return switch this typeof var void while with true false }


proc JScrDummy {} {}


proc JScr::carriageReturn {} {
	if {[lookAt [expr [getPos] - 1]] == ":"} {
		if { [lookAt [getPos]] == "\r" } {
			bind::IndentLine
			endOfLine
			insertText "\r"
		} else {
			set pos [getPos]
			endOfLine
			set t [getText $pos [getPos]]
			replaceText $pos [getPos] ""
			bind::IndentLine
			endOfLine
			insertText "\r"
			insertText $t
		}
	} else {
		insertText "\r"
	}
	catch {bind::IndentLine}
}

proc JScr::DblClick {from to} {
	global HOME
	select $from $to
	set word [getText $from $to]
	if {[grep "^${word}( |$)" [lindex [glob $HOME:JSreference:index*] 0]] != ""} {
		editMark [lindex [glob $HOME:JSreference:JS*] 0] $word -r
	}
}

set commentCharacters(JScr:General) [list "*" "//"]
set commentCharacters(JScr:Paragraph) [list "/* " " */" " * "]
set commentCharacters(JScr:Box) [list "/*" 2 "*/" 2 "*" 3]

