
namespace eval balloon {
    variable info
    variable time 650
    
    proc help {w txt} {
	variable info

	bind $w <Any-Enter> "balloon::_start $w" 
	bind $w <Any-Leave> "balloon::_hide $w"
	bind $w <Button-1> "balloon::_button $w"
	set tags [bindtags $w]
	bindtags $w [concat [lrange $tags 1 end] [lindex $tags 0]]
	
	bind $w <<Destroy>> "balloon::end $w"
	set info($w,text) [split $txt "|"]
    }

    proc forget {} {
	variable info
	if {[info exists info]} {
	    unset info
	}
    }
    
    proc end {w} {
	variable info
	unset info($w,text)
	::destroy .balloon

	catch {
	    bind $w <Any-Enter> ""
	    bind $w <Any-Leave> ""
	    bind $w <Button-1> ""
	}
	
    }

    proc _button {w} {
	variable info
	if {[info exists info($w,after)]} {
	    after cancel $info($w,after)
	    if {[winfo exists .balloon.l]} {
		_check $w
	    }
	}
    }
    
    proc _start {w} {
	variable info 
	variable time
	destroy .balloon

	set info($w,after) [after $time "balloon::_show $w"]
    }

    proc _show {w} {
	if {![winfo exists $w]} {
	    _hide $w
	    end $w
	    return
	}
	
	variable info
	variable time
	# the position of the balloon window
	set posx [expr {[winfo pointerx $w] + 20}]
	set posy [expr {[winfo pointery $w] + 20}]

	toplevel .balloon -relief ridge -borderwidth 2 -bg yellow
	wm withdraw .balloon 
	wm overrideredirect .balloon 1
	wm geometry .balloon "+${posx}+${posy}"

	set text [_text $w]
	label .balloon.l -text $text \
	  -bg yellow -fg black -bd 0 -font "helvetica 10" \
	  -justify left -wraplength 2i -padx 6 -relief solid
	pack .balloon.l

	# make it visible
	if {$text != ""} {
	    wm deiconify .balloon
	}
	
	set info($w,after) [after $time "balloon::_check $w"]
    }
    
    proc _text {w} {
	variable info
	# In principle we allow four different pieces of text to be
	# associated with each item.  In practice we only use 1 or 2.
	# This flexibility is nicely compatible with MacOS balloons.
	switch -- [winfo class $w] {
	    "Checkbutton" {
		# Checkbuttons display a different help text if the
		# box is checked or not.
		set value [uplevel \#0 set [$w cget -variable]]
		if {$value} {
		    set text [lindex $info($w,text) 2]
		} else {
		    set text [lindex $info($w,text) 0]
		}
	    }
	    default {
		set text [lindex $info($w,text) 0]
	    }
	}
    }
    
    proc _check w {
	variable info
	variable time
	if {![winfo exists $w]} {
	    catch {_hide $w}
	    end $w
	} else {
	    set text [_text $w]
	    if {$text == ""} {
		wm withdraw .balloon
	    } else {
		.balloon.l configure -text $text
		wm deiconify .balloon
	    }
	    set info($w,after) [after $time "balloon::_check $w"]
	}
    }
    
    proc _hide w {
	variable info
	if {[info exists info($w,after)]} {
	    after cancel $info($w,after)
	    unset info($w,after)
	}
    }
    
}
