/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import net.sourceforge.texlipse.builder.Builder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractBuilder
implements Runnable,
Builder {
    protected IProgressMonitor monitor;
    protected volatile boolean buildRunning;
    protected int id;

    protected AbstractBuilder(int i) {
        this.id = i;
        this.monitor = null;
        this.buildRunning = false;
    }

    public int getId() {
        return this.id;
    }

    public abstract boolean isValid();

    public void reset(IProgressMonitor mon) {
        this.monitor = mon;
        this.buildRunning = false;
    }

    public abstract String getOutputFormat();

    public abstract String getSequence();

    public void run() {
        while (this.buildRunning) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            if (!this.monitor.isCanceled()) continue;
            this.stopBuild();
        }
    }

    public abstract void stopRunners();

    public void stopBuild() {
        this.buildRunning = false;
        this.stopRunners();
    }

    public abstract void buildResource(IResource var1) throws CoreException;

    public void build(IResource resource) throws CoreException {
        if (this.monitor == null) {
            throw new IllegalStateException();
        }
        this.buildRunning = true;
        Thread buildThread = new Thread(this);
        buildThread.start();
        try {
            this.buildResource(resource);
        }
        catch (Throwable throwable) {
            this.buildRunning = false;
            try {
                buildThread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                this.monitor.setCanceled(true);
                this.stopBuild();
            }
            throw throwable;
        }
        this.buildRunning = false;
        try {
            buildThread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
            this.monitor.setCanceled(true);
            this.stopBuild();
        }
    }
}

