/*
 * Created on Mar 17, 2003
 *
 * @author henkel@cs.colorado.edu
 * 
 */
package bibtex.dom;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import bibtex.visitor.BibtexVisitor;

/**
 * This is the root of a bibtex DOM tree. It's also the factory and thus
 * the only way to create nodes.
 * 
 * @author 	henkel
 * @author 	Yann-Gal Guhneuc
 */
public class BibtexFile extends BibtexNode implements Serializable {
	public static BibtexConcatenatedValue makeConcatenatedValue(
		BibtexAbstractValue left,
		BibtexAbstractValue right) {
		return new BibtexConcatenatedValue(left, right);
	}
	public static BibtexEntry makeEntry(String entryType, String entryKey) {
		return new BibtexEntry(entryType, entryKey);
	}
	public static BibtexField makeField(
		String name,
		BibtexAbstractValue value) {
		return new BibtexField(name, value);
	}
	public static BibtexPreamble makePreamble(BibtexAbstractValue content) {
		return new BibtexPreamble(content);
	}
	public static BibtexStringReference makeReference(String key) {
		return new BibtexStringReference(key);
	}
	public static BibtexString makeString(String content) {
		// Content includes the quotes or curly braces around the string.
		return new BibtexString(content);
	}
	public static BibtexStringDefinition makeStringDefinition(
		String key,
		BibtexAbstractValue value) {
		return new BibtexStringDefinition(key, value);
	}
	public static BibtexToplevelComment makeToplevelComment(String content) {
		return new BibtexToplevelComment(content);
	}

	private final ArrayList entries = new ArrayList();

	public void accept(final BibtexVisitor visitor) {
		visitor.open(this);

		final Iterator iterator = this.entries.iterator();
		while (iterator.hasNext()) {
			final BibtexNode node = (BibtexNode) iterator.next();
			node.accept(visitor);
		}

		visitor.close(this);
	}
	public void addEntry(BibtexAbstractEntry entry) {
		this.entries.add(entry);
	}
	public List getEntries() {
		return Collections.unmodifiableList((List) entries.clone());
	}
	public void print(PrintWriter writer) {
		for (Iterator iter = this.entries.iterator(); iter.hasNext();) {
			BibtexNode node = (BibtexNode) iter.next();
			node.print(writer);
		}
		writer.flush();
	}
	public void removeEntry(BibtexAbstractEntry entry) {
		this.entries.remove(entry);
	}
	public void reset() {
		this.entries.clear();
	}
}
