{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$N-,E-,V-}
{$ENDIF}

Unit bibecond;

Interface

uses
{$IFDEF WINDOWS}
  wbibdisp,
{$ELSE}
  bibdisp,
{$ENDIF}
  bibstrg, bibvars, bibutil, rc_strng;

function  EvalCondition(Entry: EntryRecPtr; s: string;
                        printing,WinPrint: boolean; pfield: PFieldArr) : boolean;

Implementation

 
function EvalCondition(Entry: EntryRecPtr; s: string;
                       printing,WinPrint: boolean; pfield: PFieldArr) : boolean;
var
  i,indf,index,level: byte;
  stack: array[0..100] of boolean;
begin                                 { EvalCondition }
  if s='' then
  begin
    EvalCondition:=true;
    Exit;
  end;
  level:=0;
  index:=0;
  repeat
    inc(index);
    if (s[index]='*') or (s[index]='+') then
    begin
      if level<2 then FatalErrorRC(Str_ECondTooManyOps,s);
      if s[index]='*' then stack[level-1]:=stack[level] and stack[level-1]
      else stack[level-1]:=stack[level] or stack[level-1];
      level:=level-1;
    end else if s[index]='^' then
    begin
      if level<1 then FatalErrorRC(Str_ECondBadNOTLevel,s);
      stack[level]:=not stack[level];
    end else
    begin
      inc(level);;
      stack[level]:=false;
      if s[index]=#255 then                          { Printing/Displaying }
        stack[level]:=not Printing
      else if s[index]=#254 then                     { Windows printing }
        stack[level]:=WinPrint
      else if s[index]=#253 then                     { DOS }
        stack[index]:=IsDosVersion
      else if s[index]=#252 then                     { Windows }
        stack[index]:=IsWindowsVersion
      else if s[index]=#251 then                     { True }
        stack[index]:=true
      else if s[index]=#250 then                     { False }
        stack[index]:=false
      else if s[index]>=Chr(250-NumUserFormats) then { User format }
        stack[level]:=Printing and
          (ExportFormat=FirstUserFormat-1+(250-Ord(s[index])))
      else if (Ord(s[index])<128)then
      begin
        if s[index]=#50 then     { _header "type" }
          stack[level]:=(entry^.entrytype='_header')
        else
          stack[level]:=(TypeEntry^[Ord(s[index])-50]=entry^.entrytype);
      end else
      begin
        indf:=Ord(s[index])-128;
        if indf>0 then stack[level]:=(entry^.index[indf]>0) and
            ((pfield=Nil) or EditOnlyStrings or Pfield^[indf])
        else stack[level]:=false;
      end;
    end;
  until index>=length(s);
  if level<>1 then FatalErrorRC(Str_ECondIncomplete,s);
  EvalCondition:=stack[level];
end;                                  { EvalCondition }


end.
