/* texmf-common.c
   Time-stamp: "97/08/12 20:38:09 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>
#include <process.h>

#undef TEX
#undef METAFONT
#undef METAPOST

#if defined (dvibufsize)
#define TEX
#define SECTION_NAME "TeX"
#else
#if defined (gfbufsize)
#define METAFONT
#define SECTION_NAME "METAFONT"
#else
#define METAPOST
#define SECTION_NAME "MetaPost"
#endif
#endif

#undef eof			/* fixme */
#include <io.h>

#include "miktex.h"
#include "miktex.version"

#line 51 "texmf-common.c"

#define STRDUP(s) strcpy (_alloca (strlen (s) + 1), (s))

#if defined (TEX)
void
show_constants (void)

{
  printf ("            mem_max == %lu\n", (unsigned long) memmax);
  printf ("            mem_min == %lu\n", (unsigned long) memmin);
  printf ("           buf_size == %lu\n", (unsigned long) bufsize);
  printf ("         error_line == %lu\n", (unsigned long) errorline);
  printf ("    half_error_line == %lu\n", (unsigned long) halferrorlin);
  printf ("     max_print_line == %lu\n", (unsigned long) maxprintline);
  printf ("         stack_size == %lu\n", (unsigned long) stacksize);
  printf ("        max_in_open == %lu\n", (unsigned long) maxinopen);
  printf ("           font_max == %lu\n", (unsigned long) fontmax);
  printf ("      font_mem_size == %lu\n", (unsigned long) fontmemsize);
  printf ("         param_size == %lu\n", (unsigned long) paramsize);
  printf ("          nest_size == %lu\n", (unsigned long) nestsize);
  printf ("        max_strings == %lu\n", (unsigned long) maxstrings);
  printf ("   string_vacancies == %lu\n", (unsigned long) stringvacanc);
  printf ("          pool_size == %lu\n", (unsigned long) poolsize);
  printf ("          save_size == %lu\n", (unsigned long) savesize);
  printf ("          trie_size == %lu\n", (unsigned long) triesize);
  printf ("       trie_op_size == %lu\n", (unsigned long) trieopsize);
  printf ("       dvi_buf_size == %lu\n", (unsigned long) dvibufsize);
  printf ("\n");
  printf ("sizeof(memory_word) == %lu\n", (unsigned long) sizeof (memoryword));
  printf (" sizeof(glue_ratio) == %lu\n", (unsigned long) sizeof (glueratio));
  printf ("\n");
  printf ("maximum trie ops per languange == %lu",
	  ((unsigned long) 1 << sizeof (quarterword) * 8) - 1);
}
#endif

void __cdecl
ctrl_c_handler (int dummy)

{
  signal (SIGINT, SIG_IGN);
  interrupt = 1;
  signal (SIGINT, ctrl_c_handler);
}

int
mtgetoptions (void)

{
  if (signal (SIGINT, ctrl_c_handler) == SIG_ERR)
    fatal_error ("cannot install the CTRL+C handler");
}

boolean
mtopenpoolfi (alphafile *f)

{
  char filenamebuf[_MAX_PATH];
  FILE *fp;
  if (strchr (nameoffile, '/') || strchr (nameoffile, '\\'))
    strcpy (filenamebuf, nameoffile);
  else
    {
      static char buf[2048];
      char *save_name = STRDUP (nameoffile);
      char *section = SECTION_NAME;
      char *key = "Pool Dirs";
      char *filename = "fixme.pool";
      const char *path_list;
      parse_web_filename (save_name, &section, &key, &filename);
      path_list = get_search_path (section, key, buf, sizeof (buf), 0);
      if (path_list == 0
	  || ! find_file (filename, path_list, filenamebuf))
	return (false);
    }
  fp = open_file (filenamebuf, c4prmode);
  if (fp)
    {
      f->_c4p_fp = fp;
      get (*f);
      return (true);
    }
  else
    return (false);
}

static char format_name[_MAX_PATH];

boolean
mtopeninputf (alphafile *f)

{
  char filenamebuf[_MAX_PATH];
  FILE *fp;
  if (strchr (nameoffile, '/') || strchr (nameoffile, '\\'))
    strcpy (filenamebuf, nameoffile);
  else
    {
      static char buf[2048];
      char *save_name = STRDUP (nameoffile);
      char *section = SECTION_NAME;
      char *key = "Input Dirs";
      char *filename = "fixme.tex";
      const char *path_list = 0;
#if defined (TEX)
      if (*format_name)
	path_list = get_search_path (format_name, "Input Dirs", buf,
				     sizeof (buf), 0);
#endif
      parse_web_filename (save_name, &section, &key, &filename);
      if (path_list == 0)
	path_list = get_search_path (section, key, buf, sizeof (buf), 0);
      if (path_list == 0
	  || ! find_file (filename, path_list, filenamebuf))
	return (false);
    }
  fp = open_file (filenamebuf, c4prmode);
  if (fp)
    {
      f->_c4p_fp = fp;
      get (*f);
      return (true);
    }
  else
    return (false);
}

#if defined (TEX)
boolean
mtopenformat (wordfile *f)

{
  char filenamebuf[_MAX_PATH];
  char command_line[_MAX_PATH];
  char *ext;
  FILE *fp = 0;
  static char buf[2048];
  const char *path_list;
  char *save_name = STRDUP (nameoffile);
  char *section = SECTION_NAME;
  char *key = "Format Dirs";
  char *filename = "fixme.fmt";
  parse_web_filename (save_name, &section, &key, &filename);
  path_list = get_search_path (section, key, buf, sizeof (buf), 0);
  strcpy (format_name, filename);
  ext = strstr (format_name, ".fmt");
  if (ext)
    *ext = 0;
  strcpy (filenamebuf, filename);
  if (strchr(filename, '/') || strchr(filename, '\\')
      || path_list == 0
      || find_file (filename, path_list, filenamebuf))
    fp = open_file (filenamebuf, c4prbmode);
  if (fp)
    {
      f->_c4p_fp = fp;
      get (*f);
      return (true);
    }
  else
    {
      int rc;
      char *argv[10];
      int argc = 0;
      static char buf[2048];
      const char *destdir = get_search_path ("TeX", "Format Temp Dir",
					     buf, sizeof (buf), 0);
      if (destdir == 0 || ! find_executable ("MakeTeXFMT.exe", command_line))
	return (false);
      argv[argc++] = command_line;
      argv[argc++] = "-v";
      argv[argc++] = "-D";
      argv[argc++] = destdir;
      argv[argc++] = format_name;
      argv[argc++] = 0;
      rc = _spawnv (_P_WAIT, command_line, argv);
      if (rc == 0 && find_file (filename, path_list, filenamebuf))
	{
	  FILE *fp = open_file (filenamebuf, c4prbmode);
	  if (fp == 0)
	    return (false);
	  f->_c4p_fp = fp;
	  get (*f);
	  return (true);
	}
      else
	return (false);
    }
}
#endif

#ifdef METAFONT
boolean
mtopenbasefi (wordfile *f)

{
  char filenamebuf[_MAX_PATH];
  FILE *fp;
  static char buf[2048];
  const char *path_list;
  char *save_name = STRDUP (nameoffile);
  char *section = SECTION_NAME;
  char *key = "Base Dirs";
  char *filename = "fixme.base";
  parse_web_filename (save_name, &section, &key, &filename);
  path_list = get_search_path (section, key, buf, sizeof (buf), 0);
  if (strchr(filename, '/') || strchr(filename, '\\'))
    strcpy (filenamebuf, filename);
  else
    {
      if (path_list == 0
	  || ! find_file (filename, path_list, filenamebuf))
	return (false);
    }
  fp = open_file (filenamebuf, c4prbmode);
  if (fp)
    {
      f->_c4p_fp = fp;
      get (*f);
      return (true);
    }
  else
    {
      char basename[_MAX_PATH];
      char command_line[_MAX_PATH];
      char *ext;
      int rc;
      char *argv[10];
      int argc = 0;
      static char buf[2048];
      const char *destdir = get_search_path ("METAFONT", "Base Temp Dir",
					     buf, sizeof (buf), 0);
      if (destdir == 0 || ! find_executable ("MakeMFBase.exe", command_line))
	return (false);
      strcpy (basename, filename);
      ext = strstr (basename, ".base");
      if (ext)
	*ext = 0;
      argv[argc++] = command_line;
      argv[argc++] = "-v";
      argv[argc++] = "-D";
      argv[argc++] = destdir;
      argv[argc++] = basename;
      argv[argc++] = 0;
      rc = _spawnv (_P_WAIT, command_line, argv);
      if (rc == 0 && find_file (filename, path_list, filenamebuf))
	{
	  FILE *fp = open_file (filenamebuf, c4prbmode);
	  if (fp == 0)
	    return (false);
	  f->_c4p_fp = fp;
	  get (*f);
	  return (true);
	}
      else
	return (false);
    }
}
#endif

#ifdef METAPOST
boolean
mtopenmemfil (wordfile *f)

{
  char filenamebuf[_MAX_PATH];
  FILE *fp;
  static char buf[2048];
  const char *path_list;
  char *save_name = STRDUP (nameoffile);
  char *section = SECTION_NAME;
  char *key = "Mem Dirs";
  char *filename = "fixme.mem";
  parse_web_filename (save_name, &section, &key, &filename);
  path_list = get_search_path (section, key, buf, sizeof (buf), 0);
  if (strchr(filename, '/') || strchr(filename, '\\'))
    strcpy (filenamebuf, filename);
  else
    {
      if (path_list == 0
	  || ! find_file (filename, path_list, filenamebuf))
	return (false);
    }
  fp = open_file (filenamebuf, c4prbmode);
  if (fp)
    {
      f->_c4p_fp = fp;
      get (*f);
      return (true);
    }
  else
    return (false);
}
#endif

boolean
mtisprint (asciicode ch)

{
#if 1
  return (((ch >= ' ' && ch <= '~')));
#else
  return (((ch >= ' ' && ch <= '~') || (ch >= '\xa1')) ? true : false);
#endif
}

boolean
inputln (alphafile *f,
	 boolean bypasseoln)

{
  boolean _c4p_result;
  if (bypasseoln && ! feof (f->_c4p_fp))
    c4pgetc (*f);
  last = first;
  if (feof (f->_c4p_fp))
    _c4p_result = false;
  else
    {
      if (f->_c4p_buf != '\n')
	{
	  int ch;
	  size_t len;
	  buffer[last++] = f->_c4p_buf;
#if 1
	  fgets (&buffer[last], bufsize - last, f->_c4p_fp);
	  len = strlen (&buffer[last]);
	  last += len;
	  ch = buffer[last - 1];
	  if (ch == '\n')
	    last--;
	  else
	    ch = EOF;
#else
	  while ((ch = getc (f->_c4p_fp)) != EOF
		 && ch != '\n'
		 && last < bufsize)
	    buffer[last++] = ch;
#endif
	  if (ch != '\n' && ch != EOF)
	    {
	      if (
#if defined (TEX)
		  formatident == 0
#endif
#if defined (METAFONT)
		  baseident == 0
#endif
#if defined (METAPOST)
		  memident == 0
#endif
		  )
		{
		  fputs ("Buffer size exceeded!", termout._c4p_fp);
		  c4plongjmp (finbuf, 1);
		}
	      else
		{
		  curinput.locfield = first;
		  curinput.limitfield = last - 1;
		  overflow (256, bufsize);
		}
	    }
          if (last >= maxbufstack)
            {
              maxbufstack = last + 1;
              if (maxbufstack >= bufsize)
		{
		  if (
#if defined (TEX)
		  formatident == 0
#endif
#if defined (METAFONT)
		  baseident == 0
#endif
#if defined (METAPOST)
		  memident == 0
#endif
		      )
		    {
		      fputs ("Buffer size exceeded!", termout._c4p_fp);
		      c4plongjmp (finbuf, 1);
		    }
		  else
		    {
		      curinput.locfield = first;
		      curinput.limitfield = last - 1;
		      overflow (256, bufsize);
		    }
		}
            }
	  while (last > first
		 && (buffer[last - 1] == ' '
		     || buffer[last - 1] == '\t'
		     || buffer[last - 1] == '\r'))
	    last--;
	  f->_c4p_buf = '\n';
	}
      _c4p_result = true;
    }
  return (_c4p_result);
}

#if defined (TEX)
int
cmdlntobuf ()

{
  curinput.locfield = 0;
  last = c4pplen;
  memcpy (buffer, c4ppline, c4pplen);
  /* if cmdline is either 'tex FILENAME' or 'tex &FORMAT FILENAME' or
     'initex FILENAME \dump'... */
  if ((c4pargc == 2 && _access (c4pargv[1], 0) == 0)
      || (c4pargc == 3 && c4pargv[1][0] == '&' && _access (c4pargv[2], 0) == 0)
      || (c4pargc == 3 && strcmp (c4pargv[2], "\\dump") == 0
	  && _access (c4pargv[1], 0) == 0))
    {
      /* ...then convert backslashes in a filename into slashes. */
      size_t i;
      for (i = 0; i < c4pplen; i++)
	{
	  if (buffer[i] == '\\'
	      && (i + 5 > c4pplen || memcmp (&buffer[i], "\\dump", 5) != 0))
	    buffer[i] = '/';
	}
    }
  c4pplen = 0;
  return (0);
}
#endif

#if defined (METAPOST)
int
runmakempx (const char *mpname,
	    const char *mpxname)

{
  char command_line[3 * _MAX_PATH];
  if (! find_executable ("makempx.exe", command_line))
    return (0);
  sprintf (command_line + strlen (command_line), " %s.mp %s", mpname, mpxname);
  return (system (command_line) == 0);
}
#endif

/* texmf-common.c ends here */
