% york-thesis.cls
%
%% This is a class (.cls) file for LaTeX2e.
%% This is a replacement for the dissertation.sty file used with
%% LaTeX209.  Basically we want the report class with a 
%% few modifications.
%%
%% Current Maintainer:	Norman Gall
%%						Department of Philosophy
%%						The University of Calgary
%%						Calgary, Alberta, Canada
%%
%%						ngall@ucalgary.ca
%%
%% Next to last Author:	Thomas J. Stone
%%
%% Feel free to copy, modify, and distribute.
%% I am interested in any changes you make.
%% Send changes to ngall@ucalgary.ca
%%
%% This file has been changed so much from the original that I almost feel
%% justified in claiming it as my own. Of course, so many people have
%% contributed code (i.e., I have shamelessly stolen it) that I feel
%% compelled to mention them; so their names still appear.
%%
%% Please note that I have made a number of stylistic choices in how the 
%% text appears. If you feel stongly about any particular choice, give me 
%% a shout and I will see what I can do about implementing a switch. But 
%% I make no promises. Some of these choices are not negotiable. :)
%%
%% The original is based on the dissertation.sty file by Pablo A. Straub.
%% (Actually it is based on a modified version that contains 
%% modifications by Aaron E. Naiman.)
%
% Version History
% ---------------
% v0.1  1995-01-15      Test of Class file
%                       Included (Aaron Naiman's modified version) of 
%                       dissertation.sty
% v0.2  1995-01-15      Modified slightly to conform to LaTeX2e 
%						suggested standards
% v0.3  1995-01-15      Got rid of a bunch of stuff that I don't think
%                       is needed.  I.e.,  some of the cross referencing
%                       stuff.  I think that most people either won't
%                       use this or they have their own macros.
% v1.0  1995-04-25      Set up for distribution to others.
%
%   9/1997  changes by Stefan Kehrbaum (sk) to accomodate new guidelines 
%   implemented by the graduate school in summer 1997
%
% v1.1 2002-02-13	  Modifications by Norm Gall <gall@spookyhill.net>
%						for York University, Toronto, ON, Canada; 
%							a) name changed to york-thesis
%							b) added a TOC entry for the Table of 	
%								Contents
%							c) added {final | draft} option in 
%								\documentclass command
%							d) made footnote spacing single spaced in 
%								final
%							e) changed quoting environments for single 
%								spacing in final
%							f) various housekeeping functions
%
% v1.2 2002-02-15		Corrected error with bibliography toc line
%
% v1.3 2003-03-30		Corrected some typos and added an epigraph 
%							command
%
% v1.4 2003-09-07		Made subsection and subsubsection sizes more
%							sane
%
% v1.5 2003-09-20		Changed appearance of chapter titles:
%							removed \chaptername and placed the
%							section number on the same line as the 
%							label (suggested by Dave Makalsky)
%
%-- Notes -------------------------------------------------------------
%
%	a) both letterpaper and 12pt options are forced. The document can't 
%		change them.
%
%-- Identification ----------------------------------------------------
%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{york-thesis}[2003/09/20 v1.5]
%
%-- Initial Code ------------------------------------------------------
%
\RequirePackage{ifthen}
%
%-- Declaration of Options -----------------------------
% saving taken from dissertation.sty with modification
%
\newboolean{saving}

\DeclareOption{draft}{\setboolean{saving}{true}}
\DeclareOption{final}{\setboolean{saving}{false}}

\PassOptionsToClass{12pt}{report}
\PassOptionsToClass{letterpaper}{report}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}

\ExecuteOptions{draft}
%-- Execution of Options -------------------------------
\ProcessOptions
%-- Package Loading ------------------------------------
\LoadClass{report}
%-- Main Code ------------------------------------------
%
%
%     some redefinitions I need later
%
\let\oldquote\quote
\let\oldendquote\endquote
\let\oldquotation\quotation
\let\oldendquotation\endquotation
\let\oldbibliography\bibliography
\let\oldendbibliography\endbibliography
%
% masters taken from dissertation.sty with modification
%
\newboolean{masters}\setboolean{masters}{false}
\newcommand{\@thesis}{\ifthenelse{\boolean{masters}}{Thesis}{Dissertation}}
%
%
%
% 2. Margins and spacing
%
% Rules taken from York FGS Guidelines for Theses and Dissertations
%
% The style guide requires a 1.5in left and top margin.  We use 1.65in.
% The style guide requires a 1.0in right and bottom margin. 
% We use 1.15in.
%
%
% \spacing - redefine \baselinestretch and recompute \baselineskip
%            lateral effect: set typeface to normalize roman
%
\newcommand{\spacing}[1]{\renewcommand{\baselinestretch}{#1}%
			\large\normalsize}
%
\ifthenelse{\boolean{saving}}
{       % settings for draft
		\setlength {\topmargin}{0.0in}		% top margin    1.0 inch
        \setlength {\textheight}{8.5in}		% bottom margin 1.0 inch
        \setlength {\oddsidemargin}{0.0in	}	% left margin   1.0 inch
	    \setlength {\evensidemargin}{0.0in}	% right margin (ds)  1.0 inch
        \setlength {\textwidth}{6.5in}		% right margin  1.0 inch
        \spacing{1}							% single for drafts
}
{       % settings for final
		\setlength {\topmargin}{0.65in}		% top margin    1.65 inch
        \setlength {\textheight}{7.6in}		% bottom margin 1.00 inch
        \setlength {\oddsidemargin}{0.65in}	% left margin   1.65 inch
	    \setlength {\evensidemargin}{0.15in}	% right margin (ds)  1.15 inch
        \setlength {\textwidth}{5.7in}		% right margin  1.15 inch
        \setlength {\footskip}{0.7in}			% space above pg num
        \spacing{2}							% double for final
        \renewenvironment{quote}				% redefine quote 
			{\oldquote\spacing{1}}
			{\oldendquote\spacing{2}}
		\renewenvironment{quotation}			% redefine quotation
			{\oldquotation\spacing{1}}
			{\oldendquotation\spacing{2}} 
}
\setlength {\footnotesep}{14pt}		
\setlength {\headheight}{0in}			% no header
\setlength {\headsep}{0in}			% no header separation
\renewenvironment{bibliography}[1]	% automatically enter toc line
			{\addcontentsline{toc}{chapter}{Bibliography}\oldbibliography {#1}}
			{\oldendbibliography}
%
% Make footnotes single spaced
%
%			code shamelessly stolen from setspace.sty 
%				written by Geoffrey Tobin <G.Tobin@latrobe.edu.au>
%
\long\def\@footnotetext#1{%
  \insert\footins{%
    \def\baselinestretch {1}%
    \reset@font\footnotesize
    \interlinepenalty\interfootnotelinepenalty
    \splittopskip\footnotesep
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM
    \hsize\columnwidth
    \@parboxrestore
    \protected@edef\@currentlabel{%
      \csname p@footnote\endcsname\@thefnmark
    }%
    \color@begingroup
      \@makefntext{%
        \rule\z@\footnotesep\ignorespaces#1\@finalstrut\strutbox}%
    \color@endgroup}}
%
% 3. Commands to define parameters for the front matter
% 
% There are two kinds of commands that define parametters for the  front
% matter:  those  that  provide info (like \author or \abstractfile) and
% those that set flags (like \hascopyright).
% 
% The following are the definitions of the commands  that  provide  info
% (standard  LaTeX  commands  like  \author are omitted because they are
% already defined).
%
\def\department#1{\gdef\@department{#1}}
\def\abstractfile#1{\gdef\@abstractfile{#1}}
\def\masterof#1{\gdef\@masterof{#1}}
\def\acknowledgementsfile#1{\gdef\@acknowledgementsfile{#1}}
%
% The following are the initial values for some commands that 
% provide info.
%
\gdef\@author{{\it Your Full Name}}
\gdef\@title{{\it The Title of the Work}}
\gdef\@date{\number\year}
\gdef\@department{Department of Ancient Studies}
\def\@abstractfile{abstract}
\def\@acknowldgementsfile{acknowledgements}
\gdef\@masterof{Arts}
%
%
% The following are all switch setting commands along 
% with their initial values 
%
%
\newboolean{hascopyright}\setboolean{hascopyright}{true}
\newboolean{hasfigures}\setboolean{hasfigures}{false}
\newboolean{hastables}\setboolean{hastables}{false}
%
%
% 4. Command \makefrontmatter
%        
% The \makefrontmatter command creates the front matter by conditionally
% invoking other commands:
%  
%       \makeabstract, \maketitlepage, \makecopyrightpage, \makepreface,
%       \makededication, \makeacknowledgements, \tableofcontents,
%       \makelistoftables, \makelistoffigures, \makecommentpage.
%
% \makefrontmatter takes care of numbering in lowercase roman, arabic or
% none.
%
\def\makefrontmatter{
 \pagestyle {empty}
 \maketitlepage
 \makecopyrightpage
 \newpage 					% skip a page for the certificate page
 \pagestyle {plain}
 \pagenumbering {roman}
 \setcounter {page}{4}
 \@ifdefined {@abstractfile}{\makeabstract}
 \@ifdefined {@acknowledgementsfile}{\makeacknowledgements}
 \addcontentsline {toc}{chapter}{Table of Contents}
 \tableofcontents\newpage
 \ifthenelse{\boolean{hastables}}{\makelistoftables}{}
 \ifthenelse{\boolean{hasfigures}}{\makelistoffigures}{}
 \pagenumbering {arabic}
 \setcounter {page}{1}
 }
%
%
% 5. Commands to create different parts of the front matter
%
%
% \maketitlepage - create the title page according to a complex format
%
\def\maketitlepage{
 \newpage
 \vspace*{.85in}
 \begin{center}
 \spacing{1}
 {\begin{tabular}[t]{c}\@title\end{tabular}}
 \\ \hugeskip 
 \hugeskip
 \hugeskip
 \hugeskip
 {\bigskip \@author}
 \end{center}
 \hugeskip \hugeskip \hugeskip \hugeskip \hugeskip \hugeskip
 {\spacing{1}
 \begin{center}
 \ifmasters A thesis \else A dissertation \fi
          submitted to the Faculty of Graduate Studies \\
          in partial fulfilment of the requirements \\
          for the degree of \\
 \hugeskip \hugeskip \hugeskip
 \ifmasters Master of \@masterof \else Doctor of Philosophy \fi \\
 \hugeskip \hugeskip % \hugeskip
 Graduate Programme in \@department \\
 York University \\
 Toronto, Ontario \\
 \@date
 \end{center}
 \newpage}}
%
% \makecopyrightpage - create a copyright page
%
\def\makecopyrightpage{
 \newpage
 \mbox{}\par\vfill
 \ifhascopyright
  {\large
  \begin{center}
  \boldmath $\copyright$ Copyright by \\
  \@author \\
  \@date
  \end{center}}
  \vfill
 \fi
 \newpage}
%
% \makeabstract - create the abstract page(s)
%
\def\makeabstract{
 \newpage
 \addcontentsline {toc}{chapter}{Abstract}
 {\chapter*{Abstract}
 \spacing{2}
 \bigskip\par\noindent}
 \@input{\@abstractfile}
 \newpage}
%
% \makeacknowledgements - create the acknowledgements page(s)
%
\def\makeacknowledgements{
 \newpage
 \addcontentsline {toc}{chapter}{Acknowledgements}
 {\chapter*{Acknowledgements}
 \spacing{2}
 \bigskip\par\noindent}
 \@input{\@acknowledgementsfile}
 \newpage}
%
% \makelistoftables - create the list of tables
%
\def\makelistoftables{
 \newpage
 \addcontentsline {toc}{chapter}{List of Tables}
 \listoftables
 \newpage}
%
% \makelistoffigures  - create the list of figures
%
\def\makelistoffigures{
 \newpage
 \addcontentsline {toc}{chapter}{List of Figures}
 \listoffigures
 \newpage}
%
% \hugeskip - skip twice as much as the TeX command \bigskip
%
\def\hugeskip{\vskip 24pt plus 8pt minus 8pt}
%
% \@ifdefined - expand #2 if command #1 is not defined
%
\def\@ifdefined#1#2{\@ifundefined{#1}{}{#2}}
%
% \@makechapterhead \@makeschapterhead - create a chapter head
%
% These standard LaTeX commands are redefined here to use not-so-huge type
% and to provide chapters of form: N chaptername
%
\def\@makechapterhead#1{ \vspace*{50pt} { \parindent 0pt \raggedright%
	 \ifnum \c@secnumdepth >\m@ne \Large\bf 
	 \thechapter \hskip 1em \fi \Large \bf #1\par
	 \nobreak \vskip 40pt } }
%
\def\@makeschapterhead#1{ \vspace*{50pt} { \parindent 0pt \raggedright
 \Large \bf #1\par
 \nobreak \vskip 40pt } }
%
% redefine section size to the same size as subsection, etc.
%
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\large\bfseries}}
                                   
\renewcommand\subsection{\@startsection {subsection}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\normalsize\bfseries}}

\renewcommand\subsubsection{\@startsection {subsubsection}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\normalsize\bfseries}}
%
% First we rename the headings for the toc, lof, and the references.
%
\renewcommand\contentsname{Table of Contents}                                 
\renewcommand\listfigurename{List of Figures}
\renewcommand\listtablename{List of Tables}
\renewcommand\bibname{Bibliography}
%
% next we modify the definitions of \tableofcontents, \listoffigures,
% and \listoftables.  We need to have \underline{Section}   
% \underline{Page} and so forth....  basically we add the contentsheader 
% line to each of the standard definitions 
%
% we take this definition of from Aaron
%
\newcommand{\contentsheader}[2]
{       \addtocontents{#1}
        {       \centerline{\underline{#2}\protect\hfill%
			   \underline{Page}}%
        }%
}
%
\renewcommand\tableofcontents
{       \if@twocolumn
                \@restonecoltrue\onecolumn
        \else
                \@restonecolfalse
        \fi
        \chapter*{\contentsname \@mkboth        {\uppercase{\contentsname}}%
                                                {\uppercase{\contentsname}}}%
        \@starttoc{toc}%
        \if@restonecol\twocolumn\fi
}
%
\renewcommand\listoffigures
{       \if@twocolumn
                \@restonecoltrue\onecolumn
        \else
                \@restonecolfalse
        \fi
        \chapter*{\listfigurename \@mkboth      {\uppercase{\listfigurename}}%
                                                {\uppercase{\listfigurename}}}%
        \@starttoc{lof}%
        \if@restonecol\twocolumn\fi
}
%
\renewcommand\listoftables
{       \if@twocolumn
                \@restonecoltrue\onecolumn
        \else
                \@restonecolfalse
        \fi
        \chapter*{\listtablename \@mkboth       {\uppercase{\listtablename}}%
                                                {\uppercase{\listtablename}}}%
        \@starttoc{lot}%
        \if@restonecol\twocolumn\fi
}
%
%	\epigraph{text}{byline}
%
\newcommand{\epigraph}[2]{\begin{flushright}\begin{minipage}{4in}%
			\spacing{1}#1
		    \begin{flushright}#2\end{flushright}\hrule%
		    \end{minipage}\vskip 12pt\end{flushright}}
%
%% End of file `york-thesis.cls'.



