# ts_optMenu.tcl
#
# like tk_optionMenu, but with another layout and callback
# callback is: function value

proc ts_optionMenu {w varName callback firstValue args} {
  upvar #0 $varName var
  upvar #0 $callback funct

  if ![info exists var] {
    set var $firstValue
  }
  menubutton $w -textvariable $varName -indicatoron 1 -menu $w.menu \
    -relief raised -bd 1 -takefocus 1
  menu $w.menu -tearoff 0
  $w.menu add radiobutton -label $firstValue -variable $varName -command \
    "$callback"
  foreach i $args {
    $w.menu add radiobutton -label $i -variable $varName \
      -command "$callback"
  }
  bind $w <FocusIn> [bind Menubutton <Enter>]
  bind $w <FocusOut> [bind Menubutton <Leave>]
  return $w.menu
}
