%{

/*
   this script compactifies a postscript file by removing all comments
   and spaces that are not needed
*/

     void prn(char *);
     int Column=0;
%}

%%

"("([^\)\\]([\\]")")?)*")"              prn(yytext);
[ \t\n]*\{[ \t\n]*                      prn("{");
[ \t\n]*\}[ \t\n]*                      prn("}");
[ \t\n]*\[[ \t\n]*                      prn("[");
[ \t\n]*\][ \t\n]*                      prn("]");

[ \t\n]*("%"[^\n]*\n[ \t\n]*)+          prn(" ");
[ \t\n]+                                prn(" ");

[ \t\n]+/"\/"                           ;
[^ \t\n\[\]\{\}\%]+                     prn(yytext);

<<EOF>>       {
     prn("\n");
     return (0);
}

%%

void prn(char *text)
{
     if ((Column += strlen(text)) > 40)
	  printf("\n");
     printf("%s",text);
     if (Column > 40)
	  Column = 0;
}
