/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	This file contains terminal i/o routines.
 */

#include descrip
#include "types.h"

/*
 *	Routine Tty_Out outputs one line to the terminal.
 */

Tty_Out (Buffer)
char *Buffer;
{
	auto   unsigned long Sys_Status;
	static struct dsc$descriptor Buf_Desc;
	extern unsigned long Lib$Put_Output();
	extern int Check_System_Status();

	Make_VMS_Descriptor (Buffer, &Buf_Desc);
	Sys_Status = Lib$Put_Output (&Buf_Desc);
	Check_System_Status (Sys_Status);
}

/*
 *	Routine Tty_In obtains one line of input from the input.
 *	Note that we do NOT obtain input from SYS$COMMAND, since if
 *	this is running from a command file, the command file is
 *	presumed to have the correct responses within it.
 */

int Tty_In (Buffer, Buffer_Size)
char *Buffer;
unsigned short Buffer_Size;
{
	auto   unsigned long Sys_Status;
	static struct dsc$descriptor Buf_Desc;
	static unsigned short Length;
	extern unsigned long Lib$Get_Input();
	extern int Check_System_Status();
	msgcode LIB$_INPSTRTRU, RMS$_EOF;

	Set_VMS_Descriptor (Buffer, Buffer_Size-1, &Buf_Desc);
	Sys_Status = Lib$Get_Input (&Buf_Desc, 0, &Length);
	if (Sys_Status != LIB$_INPSTRTRU && (Sys_Status & 0x01) == 0) {
		if (Sys_Status != RMS$_EOF)
			Check_System_Status (Sys_Status);
		*Buffer = '\0';
		return (0);
	}
	Buffer[Length] = '\0';
	return (1);
}

/*
 *	Routine Tty_In_With_Prompt is similar to Tty_In, except a
 *	prompt string is output prior to the read for input.
 */

int Tty_In_With_Prompt (Prompt, Buffer, Buffer_Size)
char *Prompt, *Buffer;
unsigned short Buffer_Size;
{
	auto   unsigned long Sys_Status;
	static struct dsc$descriptor In_Buf_Desc, Out_Buf_Desc;
	static unsigned short Length;
	extern unsigned long Lib$Get_Input();
	extern int Check_System_Status();
	msgcode LIB$_INPSTRTRU, RMS$_EOF;

	Set_VMS_Descriptor (Buffer, Buffer_Size-1, &In_Buf_Desc);
	Make_VMS_Descriptor (Prompt, &Out_Buf_Desc);
	Sys_Status = Lib$Get_Input (&In_Buf_Desc, &Out_Buf_Desc, &Length);
	if (Sys_Status != LIB$_INPSTRTRU && (Sys_Status & 0x01) == 0) {
		if (Sys_Status != RMS$_EOF)
			Check_System_Status (Sys_Status);
		*Buffer = '\0';
		return (0);
	}
	Buffer[Length] = '\0';
	return (1);
}
