/*
 *	Tektronix 4014 header file.
 *
 *	General control character definitions:
 */

#define ENQ  0x05
#define BEL  0x07	/* Beep */
#define BS   0x08	/* Backspace */
#define HT   0x09	/* Horizontal tab */
#define LF   0x0A	/* Line feed */
#define VT   0x0B	/* Vertical tab */
#define FF   0x0C	/* Form Feed */
#define CR   0x0D	/* Carriage Return */
#define SO   0x0E	/* Shift out */
#define SI   0x0F	/* Shift in */
#define SYN  0x16	/* NOP Character */
#define ETB  0x17
#define CAN  0x18	/* Cancel */
#define SUB  0x1A
#define ESC  0x1B	/* Escape */
#define FS   0x1C	/* Enter Point PLot Mode */
#define GS   0x1D	/* Enter Graph Mode */
#define RS   0x1E	/* Enter Incremental Plot Mode */
#define US   0x1F	/* Enter Alpha Mode */
#define SP   0x20	/* Space */
#define DEL  0x7F	/* Delete or Rubout */

/*
 *	Incremental Plot Mode Commands:
 */

#define EE   0x01	/* East (Right) */
#define WW   0x02	/* West (Left) */
#define NN   0x04	/* North (Up) */
#define SS   0x08	/* South (Down) */
#define PD   0x10	/* Pen Down */
#define PU   0x20	/* Pen Up */
