/*
 *	This file contains function protocol definitions for routines
 *	in 'raster.c'.
 */

#define Raster_Word_to_Byte_M(a,b,c,d) \
    Raster_Word_to_Byte ((unsigned short) (a), \
                         (unsigned short) (b), \
                         (unsigned long *) (c), \
                         (unsigned char *) (d))

#define Compress_Raster_M(a,b,c,d) \
    Compress_Raster ((unsigned short) (a), \
                     (unsigned short) (b), \
                     (unsigned char *) (c), \
                     (unsigned char *) (d))
extern unsigned int Compress_Raster();

#define Compressed_Size_Func_M(a,b) \
    Compressed_Size_Func ((unsigned short) (a), \
                          (unsigned short) (b))
extern unsigned long Compressed_Size_Func();

#define Unpack_Raster_Data_M(a,b,c,d) \
    Unpack_Raster_Data ((unsigned short) (a), \
                        (unsigned short) (b), \
                        (unsigned char *) (c), \
                        (unsigned char *) (d))

#define Pack_Raster_Data_M(a,b,c,d) \
    Pack_Raster_Data ((unsigned short) (a), \
                      (unsigned short) (b), \
                      (unsigned char *) (c), \
                      (unsigned char *) (d))

#define Write_Raster_Column_M(a,b,c,d,e) \
    Write_Raster_Column ((unsigned short) (a), \
                         (unsigned short) (b), \
                         (unsigned short) (c), \
                         (unsigned char *) (d), \
                         (unsigned char *) (e))

#define Scan_Raster_Horizontally_M(a,b,c,d) \
    Scan_Raster_Horizontally ((unsigned short) (a), \
                              (unsigned short) (b), \
                              (unsigned short (*)[3]) (c), \
                              (unsigned char *) (d))
extern unsigned int Scan_Raster_Horizontally();

#define Scan_Raster_Vertically_M(a,b,c,d) \
    Scan_Raster_Vertically ((unsigned short) (a), \
                            (unsigned short) (b), \
                            (unsigned short (*)[3]) (c), \
                            (unsigned char *) (d))
extern unsigned int Scan_Raster_Vertically();

#define Display_Unpacked_Raster_M(a,b,c,d,e) \
    Display_Unpacked_Raster ((unsigned short) (a), \
                             (unsigned short) (b), \
                             (short) (c), \
                             (short) (d), \
                             (unsigned char *) (e))

#define Show_Raster_M(a,b,c) \
    Show_Raster ((unsigned short) (a), \
                 (unsigned short) (b), \
                 (unsigned char *) (c))

#define Overlay_Raster_M(a,b,c,d,e,f) \
    Overlay_Raster ((unsigned char *) (a), \
                    (unsigned short) (b), \
                    (unsigned short) (c), \
                    (unsigned char *) (d), \
                    (unsigned short) (e), \
                    (unsigned short) (f))

#define Reduce_Raster_M(a,b,c,d,e,f,g,h,i) \
    Reduce_Raster ((unsigned char *) (a), \
                   (unsigned short) (b), \
                   (unsigned short) (c), \
                   (short) (d), \
                   (short) (e), \
                   (unsigned short *) (f), \
                   (unsigned short *) (g), \
                   (short *) (h), \
                   (short *) (i))

#define Generate_Circle_Raster_M(a,b) \
    Generate_Circle_Raster ((unsigned int) (a), \
                            (unsigned char *) (b))

#define Reflect_Raster_M(a,b,c) \
    Reflect_Raster ((unsigned short) (a), \
                    (unsigned short) (b), \
                    (unsigned char *) (c))

#define Rotate_Raster_M(a,b,c,d,e) \
    Rotate_Raster ((unsigned short) (a), \
                   (unsigned short) (b), \
                   (unsigned char *) (c), \
                   (unsigned char *) (d), \
                   (int) (e))

#define Combine_Raster_M(a,b,c,d,e,f,g,h,i,j) \
    Combine_Raster ((unsigned char *) (a), \
                    (unsigned short) (b), \
                    (unsigned short) (c), \
                    (unsigned char *) (d), \
                    (unsigned short) (e), \
                    (unsigned short) (f), \
                    (unsigned short) (g), \
                    (unsigned short) (h), \
                    (unsigned short) (i), \
                    (int) (j))

#define Convert_Hex_to_Raster_M(a,b,c) \
    Convert_Hex_to_Raster ((unsigned short) (a), \
                           (char *) (b), \
                           (unsigned char *) (c))
extern int Convert_Hex_to_Raster();

#define Magnify_Raster_M(a,b,c,d,e) \
    Magnify_Raster ((unsigned short) (a), \
                    (unsigned short) (b), \
                    (unsigned char *) (c), \
                    (unsigned int) (d), \
                    (unsigned char *) (e))

#define Magnify_Raster_Row_M(a,b,c,d) \
    Magnify_Raster_Row ((unsigned short) (a), \
                        (unsigned int) (b), \
                        (unsigned char *) (c), \
                        (unsigned char *) (d))

#define Replicate_Raster_M(a,b,c,d,e,f) \
    Replicate_Raster ((unsigned short) (a), \
                      (unsigned short) (b), \
                      (unsigned char *) (c), \
                      (unsigned int) (d), \
                      (unsigned int) (e), \
                      (unsigned char *) (f))

#define Gcd_M(a,b) Gcd ((int) (a), (int) (b))
extern int Gcd();
