/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	This routine replaces system routine LIB$ASN_WTH_MBX, which leaves
 *	the mailbox out there (with BYTLM resources tied up) if the $ASSIGN
 *	fails (i.e., we must be able to treat a failure as non-fatal).
 */

#include descrip
#include psldef
#include dvidef
#include "vms.h"

unsigned long Lib_Asn_Wth_Mbx (DevNam, MaxMsg, BufQuo, DevChn, MbxChn)
struct dsc$descriptor *DevNam;
unsigned long *MaxMsg, *BufQuo;
unsigned short *DevChn, *MbxChn;
{
	auto   unsigned long Sys_Status;
	static struct dsc$descriptor MbxNamDesc;
	static unsigned long DVI_Status[2];
	static unsigned short Length;
	static char Mbx_Name[10];
	static struct Item_List DVI_List[] = {
		{ sizeof (Mbx_Name), DVI$_DEVNAM, &Mbx_Name[0], &Length },
		{ 0, 0, 0, 0 }
	};
	extern unsigned long Sys$CreMbx(), Lib_Assign(), Sys$GetDvIW();
	extern unsigned long Sys$DAssgn();

	Sys_Status = Sys$CreMbx (0, MbxChn, (MaxMsg == 0) ? 0 : *MaxMsg, 
				 (BufQuo == 0) ? 0 : *BufQuo, 0x0000, PSL$C_USER, 0);
	if ((Sys_Status & 0x01) != 0) {
		Sys_Status = Sys$GetDvIW (0, *MbxChn, 0, DVI_List, &DVI_Status[0], 0, 0, 0);
		if ((Sys_Status & 0x01) != 0 && ((Sys_Status = DVI_Status[0]) & 0x01) != 0) {
			Set_VMS_Descriptor (&Mbx_Name[0], Length, &MbxNamDesc);
			Sys_Status = Lib_Assign (DevNam, DevChn,
						 &MbxNamDesc, &-1, &1);
			if ((Sys_Status & 0x01) == 0) {
				Sys$DAssgn (*MbxChn);
				*MbxChn = 0;
			}
		}
	}
	return (Sys_Status);
}
