/*
 *	This file contains the definitions for the data structures
 *	used in command parsing. This implementation is a kind of
 *	hybrid between RSX-11 and VMS command parsing.
 */

#define MAX_VERB_LEN   4
#define MAX_SWITCH_LEN 4

struct Switch_Value_Table {
	char *Value_Addr;		/* Pointer to received value */
	char *Default_Value;		/* Default Value */
	unsigned short Value_Length;	/* Maximum length of value */
	unsigned short filler;
};
#define csisv(adr,len,dfl) { &adr, dfl, len, 0 }

struct Switch_Table {
	char *Switch_Name;		/* Switch name */
	struct Switch_Value_Table *Values;/* Pointer to list of values */
	unsigned int Mask;		/* Bit mask set or clear if present */
	unsigned char Min_Switch_Len;	/* Minimum length of switch name */
	unsigned char Flags;		/* Various flags */
#define NEGATABLE  0x01
#define CLEAR      0x02
#define DEFAULT    0x04
#define DEF_NEGATE 0x08
	unsigned short filler;
};
#define csisw(nam,mnl,msk,flg,swt) { nam, swt, msk, mnl, flg, 0 }

struct Verb_Table {
	char *Verb_Name;		/* The verb name */
	unsigned int *Mask_Addr;	/* Pointer to mask word */
	unsigned int *Neg_Mask_Addr;	/* Pointer to negative mask word */
	unsigned int *Def_Mask_Addr;	/* Pointer to default mask word */
	int (*Func)();			/* Function to invoke if matched */
	unsigned char Min_Verb_Len;	/* Minimum length of verb name */
	unsigned char filler[3];
};
#define csivb(nam,mnl,fnc,pos,neg,def) { nam, pos, neg, def, &fnc, mnl, {0,0,0} }
#define csiend { 0 }

struct Swval_Block {
	struct Swval_Block *Link;	/* Pointer to next block in chain */
	char Defaulted;			/* Default indicator */
	char Swval_Value[];		/* The switch value */
};

struct Switch_Block {
	struct Switch_Block *Link;	/* Pointer to next block in chain */
	struct Swval_Block *Swval;	/* Pointer to first switch value block */
	char Defaulted;			/* Default indicator */
	char Switch_Name_Value[];	/* The switch name value */
};

struct Param_Block {
	struct Param_Block *Link;	/* Pointer to next block in chain */
	struct Switch_Block *Switch;	/* Pointer to first switch block */
	struct Swval_Block *Prmval;	/* Pointer to first parameter value block */
	char Param_Value[];		/* The parameter value */
};

struct CSI_Status_Block {
	struct Verb_Table *Verb;	/* Pointer to verb entry */
	struct Param_Block *Param_Addr[10];/* Address of parameter 0 .. 9 */
	struct Param_Block *Param_Loc[10];/* Current position in parameter list */
	unsigned short N_Params;	/* Number of parameters, including verb */
	unsigned short Flags;		/* Flags word */
	unsigned int CSI_Mask;		/* Independent mask word */
};
