(* TEK4010VDU *)

VAR
   maxy       : INTEGER;     (* TEK4010 vertical coordinates are in 0..maxy;
                                some VDUs may change default value of 779     *)
   lineht     : INTEGER;     (* height in TEK4010 pixels of a text line;
                                some VDUs may change default value of 26      *)
   dragdown   : INTEGER;     (* VIS500/550 VDUs can use this value to drag
                                Terse character baseline down to TeX ref pt   *)
   havesentxy : BOOLEAN;     (* don't need to send all 4 bytes of address?    *)

PROCEDURE InitTEK4010VDU;                                  EXTERNAL;
PROCEDURE SendXY (x, y : INTEGER);                         EXTERNAL;
PROCEDURE TEK4010StartText;                                EXTERNAL;
PROCEDURE TEK4010MoveToTextLine (line : INTEGER);          EXTERNAL;
PROCEDURE TEK4010ClearScreen;                              EXTERNAL;
PROCEDURE TEK4010StartGraphics;                            EXTERNAL;
PROCEDURE TEK4010LoadFont (fontname : string;
                           fontsize : INTEGER;
                           mag, hscale, vscale : REAL);    EXTERNAL;
PROCEDURE TEK4010ShowChar (screenh, screenv : INTEGER;
                           ch : CHAR);                     EXTERNAL;
PROCEDURE TEK4010ShowRectangle (screenh, screenv,
                                width, height : INTEGER;
                                ch : CHAR);                EXTERNAL;
