/* findfile.c
 * Copyright 1985 Massachusetts Institute of Technology
 * Modifications for BSD4.1 by Piet van Oostrum - RUU - 16 May 1986
 */

#include <stdio.h>
#include <sys/types.h>
#ifdef PK
#define EXT "pk"
#define EXTL 2
#define MAG 20
#else
#define EXT "pxl"
#define EXTL 3
#define MAG 4
#endif

#ifdef BSD4.1

#include <dir.h>
#define DIR FILE
struct direct {
	short d_namlen;
	char d_name[DIRSIZ+1];
};
#define MAXNAMLEN 255
#define opendir(dir) fopen(dir,"r")
#define closedir(dir) fclose(dir)
struct direct *readdir(dirp)
DIR *dirp;

{
	static struct dir dentry;
	static struct direct de;
	register int j;

	for (;;) {
	    if (fread((char *)&dentry, sizeof(dentry), 1, dirp) != 1)
		    return (NULL);
	    if (dentry.d_ino==0
		 || dentry.d_name[0]=='.' &&  (dentry.d_name[1]=='\0'
			|| dentry.d_name[1]=='.' && dentry.d_name[2]=='\0'))
		    continue;
	    for (j=0; j<DIRSIZ; j++)
		    de.d_name[j] = dentry.d_name[j];
	    de.d_name[DIRSIZ] = '\0';
	    de.d_namlen = strlen (de.d_name);
	    return (&de);
	}
}

#else BSD4.1

#include <sys/dir.h>

#endif BSD4.1

#include "findfile.h"

int
findfileindir(area, name, mag, s, nname, nmag)
     char *area,*name,*s,*nname;
     int mag,*nmag;
{
  FILE *f;
  char buf[BUFSIZ];
  int found = 0;
    
  sprintf(s,"%s/SUBDIR",area);
  if (!access(s,0)) sprintf(s,"%s/%s/%s.%d",area,name,name,mag);
  else sprintf(s,"%s/%s.%d",area,name,mag);
  strcat(s,EXT);
  if (!access(s,4)) {
    strcpy(nname,name);
    *nmag = mag;
    return(-1);
  } else {
    sprintf(buf,"%s/NEEDED",area);
    if (!access(buf,2)) {
      sprintf(s,"%s.%d",name,mag);strcat(s,EXT);strcat(s,"\n");
      f = fopen(buf,"r+");
      while (fgets(buf,sizeof(buf),f)) if (!strcmp(buf,s)) found++;
      if (!found) fputs(s,f);
      fclose(f);
    }
    return(0);
  }
}


/* true if it found a file, false otherwise; name is in s */
int findfile(dirvec,dirveclen,area, name, mag, s, nname, nmag)
     char *dirvec[],*area,*name,*s,*nname;
     int dirveclen,mag,*nmag;
{
  int i,point;
  char family[128];

  strcpy(nname,name);
  *nmag = mag;
  point = -1;
  (void) sscanf(name,"%[^0123456789.]%d",family,&point);

  /* First check dir area given in DVI file */
  if (*area && findfileindir(area, name, mag, s, nname, nmag)) return(-1);
  
  /* Then check along dirvec */
  for (i = 0; i < dirveclen; i++) 
    if (findfileindir(dirvec[i], name, mag, s, nname, nmag)) return(-1);

  /* next check for closest magnification along dirvec */
  return(findanyfile(dirvec,dirveclen,family,point,mag,name,s,nname,nmag));
}
  
int strdiff(s1,s2)
     char *s1,*s2;
{
  register int diff = 0;

  while (*s1 && *s2) diff += abs(*s1++ - *s2++);
  while (*s1) diff += *s1++;
  while (*s2) diff += *s2++;
  return(diff);
}

scanpdir(dir,name,
	 family,point,mag,
	 bestfamily,bestname,bestpoint,bestmag,
	 min_df,min_dp,min_dm)
     char *dir,*name,*family,*bestfamily,*bestname;
     int point,mag,*bestpoint,*bestmag,*min_df,*min_dp,*min_dm;
{
  DIR *dirstream;
  struct direct *dirrecord;
  char qfamily[128];
  int qpoint,qmag,df,dp,dm;
#ifdef BSD4.1
  char ext[20];
#endif

  if (dirstream = opendir(dir)) {
    while (dirrecord = readdir(dirstream)) {
#ifndef BSD4.1
      if (!strcmp(dirrecord->d_name+dirrecord->d_namlen-EXTL,EXT))
#endif BSD4.1
      {
	qpoint = -1; qmag = -1;
#ifdef BSD4.1
	(void) sscanf(dirrecord->d_name,"%[^0123456789.]%d.%d%s",
		      qfamily,&qpoint,&qmag,ext);
	if (strcmp(ext, EXT, strlen(ext))) continue;
#else
	(void) sscanf(dirrecord->d_name,"%[^0123456789.]%d.%d",
		      qfamily,&qpoint,&qmag);
#endif
	df = strdiff(family,qfamily);
	dp = abs(point - qpoint);
	dm = abs(mag - qmag);
	if ((df < *min_df)
	    || (df == *min_df && dp < *min_dp)
	      || (df == *min_df && dp == *min_dp && dm < *min_dm)) {
		sprintf(bestname,"%s/%s",dir,dirrecord->d_name);
		strcpy(bestfamily,qfamily);
		*bestpoint = qpoint;
		*bestmag = qmag;
		*min_df = df;
		*min_dp = dp;
		*min_dm = dm;
	  }
      }
    }
    closedir(dirstream);
  }
}

scandir(dir,name,
	family,point,mag,
	bestfamily,bestname,bestpoint,bestmag,
	min_df,min_dp,min_dm)
     char *dir,*name,*family,*bestfamily,*bestname;
     int point,mag,*bestpoint,*bestmag,*min_df,*min_dp,*min_dm;
{
  DIR *dirstream;
  struct direct *dirrecord;
  int df;
  char pdir[MAXNAMLEN];

  if (dirstream = opendir(dir)) {
    while (dirrecord = readdir(dirstream)) {
      if (dirrecord->d_name[0] != '.') {
	df = strdiff(name,dirrecord->d_name);
	if (df <= *min_df) {
	  sprintf(pdir,"%s/%s",dir,dirrecord->d_name);
	  scanpdir(pdir,name,
		   family,point,mag,
		   bestfamily,bestname,bestpoint,bestmag,
		   min_df,min_dp,min_dm);
	}
      }
    }
    closedir(dirstream);
  }
}


/* finds the best match to the desired font */
int findanyfile(dirvec,dirveclen,family,point,mag,name,s,nname,nmag)
     char *dirvec[],*family,*name,*s,*nname;
     int dirveclen,point,mag,*nmag;
{
  char foo[MAXNAMLEN],bestname[MAXNAMLEN],bestfamily[128];
  int min_df,min_dp,min_dm,df,dp,dm,i,bestpoint,bestmag;
  
  bestname[0] = '\0'; 
  min_df = min_dp = min_dm = 9999999;
  for (i = 0; i < dirveclen; i++) {
    sprintf(foo,"%s/SUBDIR",dirvec[i]);
    if (!access(foo,0)) scandir(dirvec[i],name,
				family,point,mag,
				bestfamily,bestname,&bestpoint,&bestmag,
				&min_df,&min_dp,&min_dm);
    else scanpdir(dirvec[i],name,
		  family,point,mag,
		  bestfamily,bestname,&bestpoint,&bestmag,
		  &min_df,&min_dp,&min_dm);
  }
  if (bestname[0]) {
    if (bestpoint > 0) sprintf(nname,"%s%d",bestfamily,bestpoint);
    else strcpy(nname,bestfamily);
    *nmag = bestmag;
    strcpy(s,bestname);
    if ((strcmp(bestfamily,family)
	 || bestpoint != point || abs(bestmag - mag) > 2)) 
      fprintf(stderr,
	      "Substituted font %s at mag %d for %s at mag %d.\n",
	      nname,(bestmag * MAG + 3) / 6,
	      name,(mag * MAG + 3) / 6);
    return(-1);
  }
  return(0);
}
  
