/* @(#)struct.h	3.1	11/16/89 */

/**********************************************************************/
/**************************  Preliminaries  ***************************/
/**********************************************************************/

#define  STRSIZE        257

#ifdef  USEPXL
#define NPXLCHARS	128
#define LASTPXLCHAR	127
#define FIRSTPXLCHAR	0
#endif USEPXL

#define FIRSTFNTCHAR	0
#define NFNTCHARS	256
#define LASTFNTCHAR	255

#ifndef NO_PK
#define   OFFSET
#endif  NO_PK
#ifdef  USEPXL
#undef    OFFSET
#define   OFFSET
#endif USEPXL

/* definitions for loading characters */

#define NOTLOADED 0
#define TEMPORARY 1
#define PERMANENT 2

/**********************************************************************/
/*************************  Data Structures  **************************/
/**********************************************************************/

typedef char bool;

typedef struct char_entry {	/* character entry */
    int tfmw;			/* TFM width */
    short dx;			/* ho and ver escapement in pixels */
    short dy;
    unsigned short width;	/* width and height in pixels */
    unsigned short height;
    short xOffset;		/* x offset and y offset in pixels */
    short yOffset;
    short psfont;		/* if repacking, this is font number */
    short pschar;		/* and this is new font character code */
    struct {
       int isloaded;
       union {
	   long fileOffset;
	   char *pixptr; } address;
#ifndef NO_PK
       unsigned char flags;
#endif NO_PK
       } where;
   } char_entry;

typedef struct font_entry {
   struct font_entry *next;
   int k, c, s, d, a, l;
   char n[STRSIZE];	/* FNT_DEF command parameters               */
   int font_space;	/* computed from FNT_DEF s parameter        */
   int font_mag;	/* computed from FNT_DEF s and d parameters */
   float ps_scale;	/* scale in PostScript (usually 1)	    */
   char psname[STRSIZE]; /* PostScript name of the font             */
   char name[STRSIZE];	/* full name of PXL file                    */
   FILE *font_file_id;  /* file identifier (NO_FILE if none)        */
   int font_type;	/* PXL or PK or GF or PS(builtin) 	    */
   int ncdl;            /* # of different chars actually downloaded */
   int defined;		/* has the font been defined for the printer? */
   int magnification;	/* magnification read from PXL file         */
   int designsize;	/* design size read from PXL file           */
   bool dic_pack;	/* should this font be repacked?	    */
#ifdef STATS
   int nbpxl;           /* # of bytes of PXL data downloaded        */
   int ncts;            /* total # of characters typeset            */
#endif STATS
   struct char_entry ch[NFNTCHARS];/* character information         */
   } font_entry;

struct pixel_list {
    FILE *pixel_file_id;        /* file identifier                          */
    int use_count;              /* count of "opens"                         */
};

typedef struct stack_entry { int h, v, w, x, y, z, hh, vv; } stack_entry;


struct BuiltIn {
        struct BuiltIn *next;
        char TeXname[STRSIZE];	/* TeX Name of the LaserWriter font */
        char Postscript[STRSIZE];       /* Internal Name of the font */
	char Init[STRSIZE];	/* (optional) postscript init str */
	bool prefix;		/* is this a special prefix? */
	int  length;		/* length of prefix */
	int  defined;		/* has the font been defined for the printer? */
	bool onewidth;		/* are all the characters the same size? */
	struct {
	    unsigned short firstchar;
	    unsigned short lastchar;
	    unsigned long  tfmw;
	} predef;
};
