#!
#! File: FLoad.csh
#!       This C shell script implements partial downloading
#!       of the ATM compatible PostScript Type 1 fonts which 
#!       is used in specified PostScript file.
#!       This procedure is done via GhostScript & SubFont programs.
#!
#! Copyright (C) 1994, Basil K. Malyshev. All rights reserved.
#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

set FontMap=$lib/Fontmap.t1

# User can place in HOME directory file '.fload'
# which can contains redefinition of the FONTPATH, like
#   setenv FONTPATH $FONTPATH:$HOME/psfonts
# and FontMap, like:
#   set FontMap=$HOME/Fontmap.t1
# Also, user can redefine `lib` variable,
# but in this case, also redefinion of the 'FontMap` variable is required.
#
if ( -e ~/.fload ) then 
   source ~/.fload
endif

# Check of the existance GhostScript (gs) and SubFont (subfont) programs.
if ( ! -e "`which gs`" ) then
   echo "? FLoad: I can not work without GhostScript." | /bin/sh -c "cat 1>&2"
   exit
endif
if ( ! -e "`which subfont`" ) then
   echo "? FLoad: I can not work without subfont program." | /bin/sh -c "cat 1>&2"
   exit
endif

# Update map if specified option '-updatemap'
if ( "$1" == "-updatemap" ) then
  # Split FONTPATH variable into elements 
  set pathSave=($path)
  setenv PATH $FONTPATH
  set fpath=($path)
  set path=($pathSave)
  # Now go throght all font directories
  echo >$FontMap
  foreach root ($fpath)
    echo "Scanning $root directory..."
    echo "%% This part was constructed from $root directory" >>$FontMap
    pushd root
    find . -name "*.pf[ab]" -exec subfont -z$FontMap {} \;
    popd
  end
  exit
endif

# Which font set is in printer
if ( "$1" == "-p" || "$1" == "-P" ) then 
   if ( "$2" == "" ) then 
      echo "List of available font sets:" | /bin/sh -c "cat 1>&2"
      cd $lib
        ls *.FS | sed -e s/.FS// | /bin/sh -c "cat 1>&2"
      exit
   endif
   set fontSet="$2"
   shift
   shift
else
   set fontSet="Standard"
endif

if ( ! -e $lib/$fontSet.FS ) then
   echo "? $fontSet font set is not known." | /bin/sh -c "cat 1>&2"
   exit
endif

set fn=$1
set out=$2

if ( "$out" == "" ) then 
   set base=$fn:r
else
   set base=$out:r
   if ( "$out" == "$out:r" ) then 
      set out=$out.ps
   endif
endif

# If input file name is not presented show usage and list of built in fonts.
if ( "$fn" == "" ) then
   echo "Usage: (of the fload de Basil)" | /bin/sh -c "cat 1>&2"
   echo "fload [-p fontSet] <ps-file> [<output-ps-file>]" | /bin/sh -c "cat 1>&2"
   echo "  where following fontSets is available" | /bin/sh -c "cat 1>&2"
   cd $lib
     ls *.FS | sed -e s/.FS// | /bin/sh -c "cat 1>&2"
   exit
endif
if ( ! -e $fn ) then
  echo "? FLoad: I can not found file $fn." | /bin/sh -c "cat 1>&2"
  exit
endif

# Interpret file via Ghostscript to determine required fonts and characters.
set fstat=$base.fstat
echo "Process PS file $fn." | /bin/sh -c "cat 1>&2"
echo "Write font using statistic to $fstat" | /bin/sh -c "cat 1>&2"
if ( -e $fstat ) then
  /bin/rm -f $fstat
endif
gs -I${lib}:$FONTPATH -DNODISPLAY -DWRITESYSTEMDICT \
 -sOUTFILE=$fstat -sINFILE=$fn \
 -sRESIDENTFONTS=$fontSet.FS psfstat.ps quit.ps >&$base.flog
if ( -e $fstat ) then
  /bin/rm $base.flog 
else
  echo "There is some errors in scanning PS file." | /bin/sh -c "cat 1>&2"
  echo "Look GhostScript log file $base.flog for more information" | /bin/sh -c "cat 1>&2"
  echo "Most frequently error is that some font is not anywhere." | /bin/sh -c "cat 1>&2"
  exit
endif

# Began file from conventional metacomment to fit with spooler.
if ( "$out" == "" ) then 
   echo "%\!PS-Adobe-3.0"
else
   echo "Write output into file $out" | /bin/sh -c "cat 1>&2"
   echo "%\!PS-Adobe-3.0" >$out
endif

# Make partial downloading of these fonts which is available
if ( -e $base.undef ) then
   /bin/rm -f $base.undef
endif
if ( "$out" == "" ) then 
   subfont -I$FONTPATH -u$base.undef -m$FontMap -f$fstat -c$fn
else
   subfont -I$FONTPATH -u$base.undef -m$FontMap -f$fstat -c$fn >>$out
endif
if ( -e $base.undef ) then
   echo "There is unknown font(s)" | /bin/sh -c "cat 1>&2"
   cat $base.undef | /bin/sh -c "cat 1>&2"
endif
###
