/*
*  help.c:  The help, license and version functions.
*
*
*  Copyright (c) 2000 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



#ifdef RCSID
static char rcsid[]="$Id: help.c 0.06 2000/06/06 00:00:06 tom Exp $";
#endif



/*
*  Include header files.
*/
#include "tailor.h"
#if HAVE_ERRNO_H
#  include <errno.h>
#endif
#include "common.h"
#include "dvichk.h"
#include "help.h"
#include "globals.h"



/*
*  LOCAL functions prototypes.
*/
__BEGIN_DECLARATIONS
LOCAL void
my_copyright __P_((      FILE *stream,
                   const Bool  with_short_license));
LOCAL void
print_compiler_info __P_((FILE *stream));
__END_DECLARATIONS



/*
*  LOCAL variables definitions.
*/
/* Compiler infotext. */
#if USE_DE
LOCAL const char *compiler_info[]={"Kompiliert mit %s%s f%sr %s%s%s%s\n"};
#else /* !USE_DE */
LOCAL const char *compiler_info[]={N_("Compiled with %s%s for %s%s%s%s\n")};
#endif /* !USE_DE */



/*
*  Function implementations.
*/
   PUBLIC void
my_usage (stream)
   FILE *stream;
{
   fprintf(stream,
#if USE_DE
"%s %s pr%sft eine vom TeX-Formatierer erstellte %s/%s DATEI\n"
"auf den Seitenumfang des Textes ab, und gibt die ermittelten Seitenzahlen\n"
"auf dem Standardausgabe-Ger%stekanal aus.\n"
"\n"
"Aufruf: %s  [OPTION...] DATEI...\n"
"\n"
"-c %d...%d, --columns=%d...%d\tAnzahl der Spalten (Grundeinstellung:  %d)\n"
"-i,       --no-info\t\tAusgabe ohne weitere Informationen\n"
"-f,       --font-info\t\tAusgabe mit Zeichensatz-Informationen\n"
"-t,       --total-only\t\tNur Ausgabe des Seitenumfangs\n"
"-p,       --pager\t\tAusgabe wird alle %d Zeilen paginiert\n"
"-h, -?,   --help\t\tHilfetext ausgeben und Programm beenden\n"
"-V,       --version\t\tVersionsnummer ausgeben und Programm beenden\n"
"-L,       --license\t\tSoftwarelizenz ausgeben und Programm beenden",
           PRGR_NAME, VERSION_NO, UE, DVI_FN_EXTENSION, LOG_FN_EXTENSION,
           AE,
           prgr_name,
           COLUMNS_MIN, COLUMNS_MAX, COLUMNS_MIN, COLUMNS_MAX, COLUMNS_DFLT,
           SCREEN_ROWS);
#else /* !USE_DE */
_("%s %s checks for the page numbers of a formatted text\n"
"in a %s/%s FILE created by the TeX-formatter, and displays the\n"
"page numbers found on standard output channel.\n"
"\n"
"Usage: %s  [OPTION...] FILE...\n"
"\n"
"-c %d...%d, --columns=%d...%d\tnumber of columns (default:  %d)\n"
"-i,       --no-info\t\tdon't display further information\n"
"-f,       --font-info\t\tdisplay font information if available\n"
"-t,       --total-only\t\tdisplay total number of pages only\n"
"-p,       --pager\t\toutput is paginated each %d lines\n"
"-h, -?,   --help\t\tdisplay help text and exit program\n"
"-V,       --version\t\tdisplay version number and exit program\n"
"-L,       --license\t\tdisplay software license and exit program"),
           PRGR_NAME, VERSION_NO, DVI_FN_EXTENSION, LOG_FN_EXTENSION,
           prgr_name,
           COLUMNS_MIN, COLUMNS_MAX, COLUMNS_MIN, COLUMNS_MAX, COLUMNS_DFLT,
           SCREEN_ROWS);
#endif /* !USE_DE */
}



   PUBLIC void
my_license (stream)
   FILE *stream;
/*
   Prints the program-id and the license text to STREAM;
*/
{
   my_copyright (stream, FALSE);
#if USE_DE
   fprintf(stream, "Diese Software erhebt keinen Anspruch auf Vollst%sndigkeit,\n",
           AE);
   fprintf(stream, "Verwendungsf%shigkeit oder Korrektheit. F%sr JEDWEDE Sch%sden oder\n",
           AE, UE, AE);
   fputs("Verluste (implizit oder explizit), die aus Nutzung oder Handhabung\n", stream);
   fprintf(stream, "meiner Software hervorgehen, wird grunds%stzlich keine Haftung\n",
           AE);
   fprintf(stream, "%sbernommen. Bei Verwendung dieser Software erkl%srt sich der Benutzer\n",
           UE, AE);
   fputs("mit dieser Vereinbarung in vollem Umfang einverstanden.\n\n", stream);
   fprintf(stream, "Dieses Programm ist freie Software; Sie k%snnen es weitervertreiben\n",
           OE);
   fprintf(stream, "und/oder ver%sndern innerhalb der Bestimmungen der `GNU General Public\n",
           AE);
   fputs("License'; herausgegeben von der `Free Software Foundation';\n", stream);
   fprintf(stream, "in der Version 2 oder jeder sp%steren Version.\n\n",
           AE);
   fputs("Sie sollten eine Kopie der `GNU General Public License' zusammen mit\n", stream);
   fputs("diesem Programm erhalten haben; falls nicht, schreiben Sie an die:\n\n", stream);
#else /* !USE_DE */
   fputs(_("This software doesn't claim completeness, correctness or usability.\n"), stream);
   fputs(_("On principle I will not be liable for ANY damages or losses (implicit\n"), stream);
   fputs(_("or explicit), which result from using or handling my software.\n"), stream);
   fputs(_("If you use this software, you agree without any exception to this\n"), stream);
   fputs(_("agreement, which binds you LEGALLY !!\n\n"), stream);
   fputs(_("This program is free software; you can redistribute it and/or modify\n"), stream);
   fputs(_("it under the terms of the `GNU General Public License' as published by\n"), stream);
   fputs(_("the `Free Software Foundation'; either version 2, or (at your option)\n"), stream);
   fputs(_("any later version.\n\n"), stream);
   fputs(_("You should have received a copy of the `GNU General Public License'\n"), stream);
   fputs(_("along with this program; if not, write to the:\n\n"), stream);
#endif /* !USE_DE */
   fputs("   Free Software Foundation, Inc.\n", stream);
   fputs("   59 Temple Place - Suite 330\n", stream);
   fputs("   Boston, MA 02111-1307,  USA\n", stream);
}



   PUBLIC void
my_version (stream)
   FILE *stream;
/*
   Prints the program-id and all compilation flags to STREAM.
*/
{
   my_copyright (stream, TRUE);
   print_compiler_info (stream);
#if USE_DE
   fputs("\nKompilations-Optionen:", stream);
#else /* !USE_DE */
   fputs(_("\nCompilation options:"), stream);
#endif /* !USE_DE */
#ifdef DVICHK_NLS
   fputs(" NLS", stream);
#endif
#if USE_EASC
   fputs(" USE_EASC", stream);
#endif
#if USE_DE
   fputs(" USE_DE", stream);
#endif
#if USE_DE
   fprintf(stream, "\n\nFehlerberichte via eMail an <%s>.\n", BUG_REPORT_ADR);
#else /* !USE_DE */
   fprintf(stream, _("\n\nEmail bug reports to <%s>.\n"), BUG_REPORT_ADR);
#endif /* !USE_DE */
}



   LOCAL void
my_copyright (stream, with_short_license)
         FILE *stream;
   const Bool  with_short_license;
/*
   Prints the program-id and copyright text to STREAM
*/
{
   fprintf(stream, "%s (%s) %s\n", prgr_name, PACKAGE, VERSION_NO);
   if (!with_short_license)
     S_NEWLINE(stream);
   fputs(COPYRIGHT_TXT, stream);
   S_NEWLINE(stream);
   if (with_short_license)
    {
#if USE_DE
      fputs("Dies ist freie Software; in den Quellen befindet sich die Lizenz-\n", stream);
      fprintf(stream, "und Kopierbedingung.  Es gibt KEINERLEI Garantie, nicht einmal f%sr\n",
              UE);
      fputs("die TAUGLICHKEIT oder die VERWENDBARKEIT ZU EINEM ANGEGEBENEN ZWECK.", stream);
#else /* !USE_DE */
      fputs(_("This is free software; see the source for copying conditions.\n"), stream);
      fputs(_("There is NO warranty, without even the implied warranty of\n"), stream);
      fputs(_("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."), stream);
#endif /* !USE_DE */
      S_NEWLINE(stream);
    }
   S_NEWLINE(stream);
}



/*
   Writes an informational text to STREAM using the central output function
     showing the date, compiler and operating system used.
   The code is taken from `zip21' source package and adjusted to DVIChk's needs.
   Special thanks to the Info-ZIP group (`http://quest.jpl.nasa.gov/Info-ZIP/'),
     which merely granted the permission to use their `version_local()' function
     of `zip-2.1' in a modified way for DVIChk (the `print_compiler_info()'
     function is based on copyrighted code by the Info-ZIP group).
*/
#if defined(MSDOS)
   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
#if defined(__DJGPP__) || defined(__WATCOMC__) || (defined(_MSC_VER) && (_MSC_VER != 800))
   char buf[80];
#endif


   fprintf(stream, _(*compiler_info),

#ifdef __GNUC__
#  ifdef __DJGPP__
   (sprintf(buf, "djgpp v%d / gcc ", __DJGPP__), buf),
#  else
#    ifdef __GO32__           /* __GO32__ is defined as "1" only (sigh) */
   "djgpp v1.x / gcc ",
#    else
#      ifdef __EMX__            /* ...so is __EMX__ (double sigh) */
   "emx+gcc ",
#      else
   "gcc ",
#      endif
#    endif
#  endif
   __VERSION__,
#else
#  ifdef __WATCOMC__
#    if (__WATCOMC__ % 10 > 0)
/* We do this silly test because __WATCOMC__ gives two digits for the  */
/* minor version, but Watcom packaging prefers to show only one digit. */
   (sprintf(buf, "Watcom C/C++ %d.%02d", __WATCOMC__ / 100,
            __WATCOMC__ % 100), buf), "",
#    else
   (sprintf(buf, "Watcom C/C++ %d.%d", __WATCOMC__ / 100,
            (__WATCOMC__ % 100) / 10), buf), "",
#    endif
#  else
#    ifdef __TURBOC__
#      ifdef __BORLANDC__
   "Borland C++",
#        if (__BORLANDC__ < 0x0200)
   " 1.0",
#        else
#          if (__BORLANDC__ == 0x0200)   /* James:  __TURBOC__ = 0x0297 */
   " 2.0",
#          else
#            if (__BORLANDC__ == 0x0400)
   " 3.0",
#            else
#              if (__BORLANDC__ == 0x0410)   /* __BCPLUSPLUS__ = 0x0310 */
   " 3.1",
#              else
#                if (__BORLANDC__ == 0x0452)   /* __BCPLUSPLUS__ = 0x0320 */
#                  if USE_DE
   " 4.0 oder 4.02",
#                  else /* !USE_DE */
   _(" 4.0 or 4.02"),
#                  endif /* !USE_DE */
#                else
#                  if (__BORLANDC__ == 0x0460)   /* __BCPLUSPLUS__ = 0x0340 */
   " 4.5",
#                  else
#                    if (__BORLANDC__ == 0x0500)   /* __TURBOC__ = 0x0500 */
   " 5.0",
#                    else
#                      if USE_DE
   " neuer als 5.0",
#                      else /* !USE_DE */
   _(" later than 5.0"),
#                      endif /* !USE_DE */
#                    endif
#                  endif
#                endif
#              endif
#            endif
#          endif
#        endif
#      else
   "Turbo C",
#        if (__TURBOC__ >= 0x0400)     /* Kevin:  3.0 -> 0x0401 */
#          if USE_DE
   "++ 3.0 oder neuer",
#          else /* !USE_DE */
   _("++ 3.0 or later"),
#          endif /* !USE_DE */
#        else
#          if (__TURBOC__ == 0x0295)     /* [661] vfy'd by Kevin */
   "++ 1.0",
#          else
#            if ((__TURBOC__ >= 0x018d) && (__TURBOC__ <= 0x0200))  /* James: 0x0200 */
   " 2.0",
#            else
#              if (__TURBOC__ > 0x0100)
   " 1.5",                    /* James:  0x0105? */
#              else
   " 1.0",                    /* James:  0x0100 */
#              endif
#            endif
#          endif
#        endif
#      endif
#    else
#      ifdef MSC
   "Microsoft C ",
#        ifdef _MSC_VER
#          if (_MSC_VER == 800)
   "8.0/8.0c (Visual C++ 1.0/1.5)",
#          else
   (sprintf(buf, "%d.%02d", _MSC_VER/100, _MSC_VER%100), buf),
#          endif
#        else
#          if USE_DE
   "5.1 oder aelter",
#          else /* !USE_DE */
   _("5.1 or earlier"),
#          endif /* !USE_DE */
#        endif
#      else
#        if USE_DE
   "unbekannter Kompilierer", "",
#        else /* !USE_DE */
   _("unknown compiler"), "",
#        endif /* !USE_DE */
#      endif /* MSC */
#    endif /* __TURBOC__ */
#  endif /* __WATCOMC__ */
#endif /* __GNUC__ */

#if USE_DE
   UE,
#endif
   "MS-DOS",

#if (defined(__GNUC__) || (defined(__WATCOMC__) && defined(__386__)))
   " (32-bit)",
#else
#  if defined(M_I86HM) || defined(__HUGE__)
   " (16-bit, huge)",
#  else
#    if defined(M_I86LM) || defined(__LARGE__)
   " (16-bit, large)",
#    else
#      if defined(M_I86MM) || defined(__MEDIUM__)
   " (16-bit, medium)",
#      else
#        if defined(M_I86CM) || defined(__COMPACT__)
   " (16-bit, compact)",
#        else
#          if defined(M_I86SM) || defined(__SMALL__)
   " (16-bit, small)",
#          else
#            if defined(M_I86TM) || defined(__TINY__)
   " (16-bit, tiny)",
#            else
   " (16-bit)",
#            endif
#          endif
#        endif
#      endif
#    endif
#  endif
#endif

#if USE_DE
   " am ", __DATE__
#else /* !USE_DE */
   _(" on "), __DATE__
#endif /* !USE_DE */
   );
}
#else /* !MSDOS */
#  if defined(WIN32)
   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
#if (defined(_MSC_VER) || defined(__WATCOMC__))
   char buf[80];
#endif


   fprintf(stream, _(*compiler_info),

#ifdef _MSC_VER  /* MSC == MSVC++, including the SDK compiler */
   (sprintf(buf, "Microsoft C %d.%02d ", _MSC_VER/100, _MSC_VER%100), buf),
#  if (_MSC_VER == 800)
   "(Visual C++ v1.1)",
#  else
#    if (_MSC_VER == 850)
   "(Windows NT v3.5 SDK)",
#    else
#      if (_MSC_VER == 900)
   "(Visual C++ v2.0/v2.1)",
#      else
#        if (_MSC_VER == 1000)
   "(Visual C++ v4.0)",
#        else
#          if (_MSC_VER == 1010)
   "(Visual C++ v4.1)",
#          else
#            if (_MSC_VER > 800)
   "(Visual C++)",
#            else
#              if USE_DE
   "(fehlerhafte Version)",
#              else /* !USE_DE */
   _("(bad version)"),
#              endif /* !USE_DE */
#            endif
#          endif
#        endif
#      endif
#    endif
#  endif
#endif /* _MSC_VER */

#ifdef __WATCOMC__
#  if (__WATCOMC__ % 10 > 0)
/* We do this silly test because __WATCOMC__ gives two digits for the  */
/* minor version, but Watcom packaging prefers to show only one digit. */
   (sprintf(buf, "Watcom C/C++ %d.%02d", __WATCOMC__ / 100,
            __WATCOMC__ % 100), buf), "",
#  else
   (sprintf(buf, "Watcom C/C++ %d.%d", __WATCOMC__ / 100,
            (__WATCOMC__ % 100) / 10), buf), "",
#  endif /* __WATCOMC__ % 10 > 0 */
#endif /* __WATCOMC__ */

#ifdef __TURBOC__
#  ifdef __BORLANDC__
   "Borland C++",
#    if (__BORLANDC__ == 0x0452)   /* __BCPLUSPLUS__ = 0x0320 */
#      if USE_DE
   " 4.0 oder 4.02",
#      else /* !USE_DE */
   _(" 4.0 or 4.02"),
#      endif /* !USE_DE */
#    else
#      if (__BORLANDC__ == 0x0460)   /* __BCPLUSPLUS__ = 0x0340 */
   " 4.5",
#      else
#        if (__BORLANDC__ == 0x0500)   /* __TURBOC__ = 0x0500 */
   " 5.0",
#        else
#          if USE_DE
   " neuer als 5.0",
#          else /* !USE_DE */
   _(" later than 5.0"),
#          endif /* !USE_DE */
#        endif
#      endif
#    endif
#  else /* !__BORLANDC__ */
   "Turbo C",
#    if (__TURBOC__ >= 0x0400)     /* Kevin:  3.0 -> 0x0401 */
#      if USE_DE
   "++ 3.0 oder neuer",
#      else /* !USE_DE */
   _("++ 3.0 or later"),
#      endif /* !USE_DE */
#    else
#      if (__TURBOC__ == 0x0295)     /* [661] vfy'd by Kevin */
   "++ 1.0",
#      endif
#    endif
#  endif /* __BORLANDC__ */
#endif /* __TURBOC__ */

#if !defined(__TURBOC__) && !defined(__WATCOMC__) && !defined(_MSC_VER)
#  if USE_DE
   "unbekannter Kompilierer (SDK?)", "",
#  else /* !USE_DE */
   _("unknown compiler (SDK?)"), "",
#  endif /* !USE_DE */
#endif

#if USE_DE
   UE,
#endif
   "\n\tWindows 95 / Windows NT", " (32-bit)",

#if USE_DE
   " am ", __DATE__
#else /* !USE_DE */
   _(" on "), __DATE__
#endif /* !USE_DE */
   );
}
#  else /* !WIN32 */
#    if defined(OS2)
   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
#if defined(__IBMC__) || defined(__WATCOMC__) || defined(_MSC_VER)
   char buf[80];
#endif


   fprintf(stream, _(*compiler_info),

#ifdef __GNUC__
#  ifdef __EMX__  /* __EMX__ is defined as "1" only (sigh) */
   "emx+gcc ", __VERSION__,
#  else
   "gcc/2 ", __VERSION__,
#  endif
#else
#  ifdef __IBMC__
   "IBM ",
#    if (__IBMC__ < 200)
   (sprintf(buf, "C Set/2 %d.%02d", __IBMC__/100,__IBMC__%100), buf),
#    else
#      if (__IBMC__ < 300)
   (sprintf(buf, "C Set++ %d.%02d", __IBMC__/100,__IBMC__%100), buf),
#      else
   (sprintf(buf, "Visual Age C++ %d.%02d", __IBMC__/100,__IBMC__%100), buf),
#      endif
#    endif
#  else
#    ifdef __WATCOMC__
   "Watcom C", (sprintf(buf, " (__WATCOMC__ = %d)", __WATCOMC__), buf),
#    else
#      ifdef __TURBOC__
#        ifdef __BORLANDC__
   "Borland C++",
#          if (__BORLANDC__ < 0x0200)
   " 1.0",
#          else
#            if (__BORLANDC__ == 0x0200)
   " 2.0",
#            else
#              if (__BORLANDC__ == 0x0400)
   " 3.0",
#              else
#                if (__BORLANDC__ == 0x0410)
   " 3.1",
#                else
#                  if (__BORLANDC__ == 0x0452)
   " 4.0",
#                  else                    /* these two are guesses based on DOS version */
#                    if (__BORLANDC__ == 0x0460)
   " 4.5",
#                    else
#                      if USE_DE
   " neuer als 4.5",
#                      else /* !USE_DE */
   _(" later than 4.5"),
#                      endif /* !USE_DE */
#                    endif
#                  endif
#                endif
#              endif
#            endif
#          endif
#        else
   "Turbo C",
#          if (__TURBOC__ >= 661)
#            if USE_DE
   "++ 1.0 oder neuer",
#            else /* USE_DE */
   _("++ 1.0 or later"),
#            endif /* USE_DE */
#          else
#            if (__TURBOC__ == 661)
   " 3.0?",
#            else
#              if (__TURBOC__ == 397)
   " 2.0",
#              else
#                if USE_DE
   " 1.0 oder 1.5?",
#                else /* !USE_DE */
   _(" 1.0 or 1.5?"),
#                endif /* !USE_DE */
#              endif
#            endif
#          endif
#        endif
#      else
#        ifdef MSC
   "Microsoft C ",
#          ifdef _MSC_VER
   (sprintf(buf, "%d.%02d", _MSC_VER/100, _MSC_VER%100), buf),
#          else
#            if USE_DE
   "5.1 oder aelter",
#            else /* !USE_DE */
   _("5.1 or earlier"),
#            endif /* !USE_DE */
#          endif
#        else
#          if USE_DE
   "unbekannter Kompilierer", "",
#          else /* !USE_DE */
   _("unknown compiler"), "",
#          endif /* !USE_DE */
#        endif /* MSC */
#      endif /* __TURBOC__ */
#    endif /* __WATCOMC__ */
#  endif /* __IBMC__ */
#endif /* __GNUC__ */

#if USE_DE
   UE,
#endif
   "OS/2",

/* GRR:  does IBM C/2 identify itself as IBM rather than Microsoft? */
#if (defined(MSC) || (defined(__WATCOMC__) && !defined(__386__)))
#  if defined(M_I86HM) || defined(__HUGE__)
   " (16-bit, huge)",
#  else
#    if defined(M_I86LM) || defined(__LARGE__)
   " (16-bit, large)",
#    else
#      if defined(M_I86MM) || defined(__MEDIUM__)
   " (16-bit, medium)",
#      else
#        if defined(M_I86CM) || defined(__COMPACT__)
   " (16-bit, compact)",
#        else
#          if defined(M_I86SM) || defined(__SMALL__)
   " (16-bit, small)",
#          else
#            if defined(M_I86TM) || defined(__TINY__)
   " (16-bit, tiny)",
#            else
   " (16-bit)",
#            endif
#          endif
#        endif
#      endif
#    endif
#  endif
#else
   " 2.x (32-bit)",
#endif

#if USE_DE
   " am ", __DATE__
#else /* !USE_DE */
   _(" on "), __DATE__
#endif /* !USE_DE */
   );
}
#    else /* !OS2 */
#      if defined(ACORN)
   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
   fprintf(stream, _(*compiler_info),

#ifdef __GNUC__
   "gcc ", __VERSION__,
#else
#  ifdef __CC_NORCROFT
   "Norcroft ", "cc",
#  else
   "cc", "",
#  endif
#endif

#if USE_DE
   UE,
#endif

   "RISC OS",

   " (Acorn Computers Ltd)",

#if USE_DE
   " am ", __DATE__
#else /* !USE_DE */
   _(" on "), __DATE__
#endif /* !USE_DE */
   );
}
#      else /* !ACORN */
#        if defined(AMIGA)

/* NOTE:  the following include depends upon the environment
 *        variable $Workbench to be set correctly.  (Set by
 *        default, by kickstart during startup)
 */
int WBversion = (int)
/*
#include "ENV:Workbench"
*/
10
;

   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
/* Define buffers. */

   char buf1[40];  /* compiler name */
   char buf2[40];  /* revstamp */
   char buf3[40];  /* OS version*/

/* format "with" name strings */

#ifdef __SASC
   strcpy(buf1, "SAS/C ");
#else
#  ifdef LATTICE
   strcpy(buf1, "Lattice C ");
#  else
#    ifdef AZTEC_C
   strcpy(buf1, "Manx Aztec C ");
#    else
#      ifdef __GNUC__
   strcpy(buf1, "gcc ");
#      else
#        if USE_DE
   strcpy(buf1, "unbekannt ");
#        else /* !USE_DE */
   strcpy(buf1, _("unknown "));
#        endif /* !USE_DE */
#      endif
#    endif
#  endif
#endif

/* Define revision, date, and time strings.
 * NOTE:  Do not calculate run time, be sure to use time compiled.
 * Pass these strings via your makefile if undefined.
 */

#if defined(__VERSION__) && defined(__REVISION__)
#  if USE_DE
   sprintf(buf2, "Version %d.%d", __VERSION__, __REVISION__);
#  else /* !USE_DE */
   sprintf(buf2, _("version %d.%d"), __VERSION__, __REVISION__);
#  endif /* !USE_DE */
#else
#  ifdef __VERSION__
#    if USE_DE
   sprintf(buf2, "Version %d", __VERSION__);
#    else /* !USE_DE */
   sprintf(buf2, _("version %d"), __VERSION__);
#    endif /* !USE_DE */
#  else
#    if USE_DE
   sprintf(buf2, "unbekannte Version");
#    else /* !USE_DE */
   sprintf(buf2, _("unknown version"));
#    endif /* !USE_DE */
#  endif
#endif

/* "under" */
/*
   strcpy(buf3, "AmigaDOS ");
*/
   sprintf(buf3, "v%d", WBversion);

#if USE_DE
   fprintf(stream, _(*compiler_info), buf1, buf2, UE, "AmigaDOS", buf3, " am ", __DATE__);
#else /* !USE_DE */
   fprintf(stream, _(*compiler_info), buf1, buf2, "AmigaDOS", buf3, _(" on "), __DATE__);
#endif /* !USE_DE */
}
#        else /* !AMIGA */
#          if defined(ATARI)
   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
#ifdef __TURBOC__
   char buf[40];
#endif


   fprintf(stream, _(*compiler_info),

#ifdef __GNUC__
   "gcc ", __VERSION__,
#else
#  ifdef __any_other_unix_like_compiler__   /* !!! FIXME */
#    if USE_DE
   "cc ", (sprintf(buf, "Version %d", _RELEASE), buf),
#    else /* !USE_DE */
   "cc ", (sprintf(buf, _("version %d"), _RELEASE), buf),
#    endif /* !USE_DE */
#  else
#    ifdef __TURBOC__
   "Turbo C", (sprintf(buf, " (0x%04x = %d)", __TURBOC__, __TURBOC__), buf),
#    else
#      if USE_DE
   "unbekannter Kompilierer", "",
#      else /* !USE_DE */
   _("unknown compiler"), "",
#      endif /* !USE_DE */
#    endif
#  endif
#endif

#if USE_DE
   UE,
#endif

#ifdef __MINT__
   "Atari TOS/MiNT",
#else
   "Atari TOS",
#endif

   " (Atari ST/TT/Falcon030)",

#if USE_DE
   " am ", __DATE__
#else /* !USE_DE */
   _(" on "), __DATE__
#endif /* !USE_DE */
   );
}
#          else /* !ATARI */
#            if defined(__50SERIES)   /* Prime/PRIMOS */
   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
   fprintf(stream, _(*compiler_info),

#ifdef __GNUC__
   "gcc ", __VERSION__,
#else
   "cc", "",
#endif

#if USE_DE
   UE,
#endif

   "PRIMOS",

   " (Prime Computer Inc)",

#if USE_DE
   " am ", __DATE__
#else /* !USE_DE */
   _(" on "), __DATE__
#endif /* !USE_DE */
   );
}
#            else /* !__50SERIES */
#              if defined(VAXC) || defined(VMS)   /* DEC Vax */
   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
#ifdef VMS_VERSION
   char buf[40];
#endif
#ifdef __DECC_VER
   char buf2[40];
   int  vtyp;
#endif

/*  DEC C in ANSI mode does not like "#ifdef MACRO" inside another
    macro when MACRO is equated to a value (by "#define MACRO 1").   */

   fprintf(stream, _(*compiler_info),

#ifdef __GNUC__
   "gcc ", __VERSION__,
#else
#  if defined(DECC) || defined(__DECC) || defined (__DECC__)
   "DEC C",
#    ifdef __DECC_VER
   (sprintf(buf2, " %c%d.%d-%03d",
            ((vtyp = (__DECC_VER / 10000) % 10) == 6 ? 'T' :
             (vtyp == 8 ? 'S' : 'V')),
            __DECC_VER / 10000000,
            (__DECC_VER % 10000000) / 100000, __DECC_VER % 1000), buf2),
#    else
   "",
#    endif
#  else
#    ifdef VAXC
   "VAX C", "",
#    else
#      if USE_DE
   "unbekannter Kompilierer", "",
#      else /* !USE_DE */
   _("unknown compiler"), "",
#      endif /* !USE_DE */
#    endif
#  endif
#endif

#if USE_DE
   UE,
#endif

#ifdef VMS_VERSION
#  if defined(__alpha)
   "OpenVMS",   /* version has trailing spaces ("V6.1   "), so truncate: */
#    if USE_DE
   (sprintf(buf, " (%.4s f%sr Alpha)", VMS_VERSION), buf, UE),
#    else /* !USE_DE */
   (sprintf(buf, _(" (%.4s for Alpha)"), VMS_VERSION), buf),
#    endif /* !USE_DE */
#  else /* VAX */
   (VMS_VERSION[1] >= '6')? "OpenVMS" : "VMS",
#    if USE_DE
   (sprintf(buf, " (%.4s f%sr VAX)", VMS_VERSION), buf, UE),
#    else /* !USE_DE */
   (sprintf(buf, _(" (%.4s for VAX)"), VMS_VERSION), buf),
#    endif /* !USE_DE */
#  endif
#else
   "VMS", "",
#endif /* ?VMS_VERSION */

#if USE_DE
   " am ", __DATE__
#else /* !USE_DE */
   _(" on "), __DATE__
#endif /* !USE_DE */
   );
}
#              else /* default: UNIX */
#if defined(__NetBSD__) || defined(__FreeBSD__) || defined(__386BSD__) || defined(__bsdi__)
#include <sys/param.h> /* for the BSD4_4 define */
#endif

   LOCAL void
print_compiler_info (stream)
   FILE *stream;
{
#if defined(CRAY) || defined(NX_CURRENT_COMPILER_RELEASE) || defined(NetBSD)
   char buf1[40];
#  if defined(CRAY) || defined(NX_CURRENT_COMPILER_RELEASE)
   char buf2[40];
#  endif
#endif

    /* Pyramid, NeXT have problems with huge macro expansion, too:  no Info() */
    fprintf(stream, _(*compiler_info),

#ifdef __GNUC__
#  ifdef NX_CURRENT_COMPILER_RELEASE
   (sprintf(buf1, "NeXT DevKit %d.%02d ", NX_CURRENT_COMPILER_RELEASE/100,
    NX_CURRENT_COMPILER_RELEASE%100), buf1),
    (strlen(__VERSION__) > 8)? "(gcc)" :
     (sprintf(buf2, "(gcc %s)", __VERSION__), buf2),
#  else
   "gcc ", __VERSION__,
#  endif
#else
#  if defined(CRAY) && defined(_RELEASE)
#    if USE_DE
   "cc ", (sprintf(buf1, "Version %d", _RELEASE), buf1),
#    else /* !USE_DE */
   "cc ", (sprintf(buf1, _("version %d"), _RELEASE), buf1),
#    endif /* !USE_DE */
#  else
#    ifdef __VERSION__
   "cc ", __VERSION__,
#    else
   "cc", "",
#    endif
#  endif
#endif

#if USE_DE
   UE,
#endif

   "Unix",

#if defined(sgi) || defined(__sgi)
   " (Silicon Graphics IRIX)",
#else
#  ifdef sun
#    ifdef sparc
#      ifdef __SVR4
   " (Sun Sparc/Solaris)",
#      else /* may or may not be SunOS */
   " (Sun Sparc)",
#      endif
#    else
#      if defined(sun386) || defined(i386)
   " (Sun 386i)",
#      else
#        if defined(mc68020) || defined(__mc68020__)
   " (Sun 3)",
#        else /* mc68010 or mc68000:  Sun 2 or earlier */
   " (Sun 2)",
#        endif
#      endif
#    endif
#  else
#    ifdef __hpux
   " (HP/UX)",
#    else
#      ifdef __osf__
   " (DEC OSF/1)",
#      else
#        ifdef _AIX
   " (IBM AIX)",
#        else
#          ifdef aiws
   " (IBM RT/AIX)",
#          else
#            if defined(CRAY) || defined(cray)
#              ifdef _UNICOS
   (sprintf(buf2, " (Cray UNICOS release %d)", _UNICOS), buf2),
#              else
   " (Cray UNICOS)",
#              endif
#            else
#              if defined(uts) || defined(UTS)
   " (Amdahl UTS)",
#              else
#                ifdef NeXT
#                  ifdef mc68000
   " (NeXTStep/black)",
#                  else
   " (NeXTStep for Intel)",
#                  endif
#                else              /* the next dozen or so are somewhat order-dependent */
#                  if defined(linux) || defined(__linux__)
#                    ifdef __ELF__
   " (Linux ELF)",
#                    else
   " (Linux a.out)",
#                    endif
#                  else
#                    ifdef MINIX
   " (Minix)",
#                    else
#                      ifdef M_UNIX
   " (SCO Unix)",
#                      else
#                        ifdef M_XENIX
   " (SCO Xenix)",
#                        else
#                          ifdef __NetBSD__
#                            ifdef NetBSD0_8
#                              if NetBSD0_8 == 1
   " (NetBSD 0.8)",
#                              else
   (sprintf(buf1, " (NetBSD 0.8%c)", (char) (NetBSD0_8 + '@')), buf1),
#                              endif
#                            else
#                              ifdef NetBSD0_9
#                                if NetBSD0_9 == 1
   " (NetBSD 0.9)",
#                                else
   (sprintf(buf1, " (NetBSD 0.9%c)", (char)(NetBSD0_9 + 'A' - 2)), buf1),
#                                endif
#                              else
#                                ifdef NetBSD1_0
#                                  if NetBSD1_0 == 1
   " (NetBSD 1.0)",
#                                  else
   (sprintf(buf1, " (NetBSD 1.0%c)", (char)(NetBSD1_0 + 'A' - 2)), buf1),
#                                  endif
#                                else
#                                  ifdef NetBSD1_1
#                                    if NetBSD1_1 == 1
   " (NetBSD 1.1)",
#                                    else
   (sprintf(buf1, " (NetBSD 1.1%c)", (char)(NetBSD1_1 + 'A' - 2)), buf1),
#                                    endif
#                                  else
#                                    if USE_DE
   (BSD4_4 == 0.5)? " (NetBSD vor 0.9)" : " (NetBSD 1.2 oder neuer)",
#                                    else /* !USE_DE */
   (BSD4_4 == 0.5)? _(" (NetBSD before 0.9)") : _(" (NetBSD 1.2 or later)"),
#                                    endif /* !USE_DE */
#                                  endif
#                                endif
#                              endif
#                            endif
#                          else
#                            ifdef __FreeBSD__
#                              if USE_DE
   (BSD4_4 == 0.5)? " (FreeBSD 1.x)" : " (FreeBSD 2.0 oder neuer)",
#                              else /* !USE_DE */
   (BSD4_4 == 0.5)? " (FreeBSD 1.x)" : _(" (FreeBSD 2.0 or later)"),
#                              endif /* !USE_DE */
#                            else
#                              ifdef __bsdi__
#                                if USE_DE
   (BSD4_4 == 0.5)? " (BSD/386 1.0)" : " (BSD/386 1.1 oder neuer)",
#                                else /* !USE_DE */
   (BSD4_4 == 0.5)? " (BSD/386 1.0)" : _(" (BSD/386 1.1 or later)"),
#                                endif /* !USE_DE */
#                              else
#                                ifdef __386BSD__
   (BSD4_4 == 1)? " (386BSD, post-4.4 release)" : " (386BSD)",
#                                else
#                                  if defined(i486) || defined(__i486) || defined(__i486__)
   " (Intel 486)",
#                                  else
#                                    if defined(i386) || defined(__i386) || defined(__i386__)
   " (Intel 386)",
#                                    else
#                                      ifdef pyr
   " (Pyramid)",
#                                      else
#                                        if defined(ultrix) || defined(__ultrix)
#                                          if defined(mips) || defined(__mips)
   " (DEC/MIPS)",
#                                          else
#                                            if defined(vax) || defined(__vax)
   " (DEC/VAX)",
#                                            else /* __alpha? */
   " (DEC/Alpha)",
#                                            endif
#                                          endif
#                                        else
#                                          ifdef gould
   " (Gould)",
#                                          else
#                                            ifdef MTS
   " (MTS)",
#                                            else
#                                              ifdef __convexc__
   " (Convex)",
#                                              else
   "",
#                                              endif /* Convex */
#                                            endif /* MTS */
#                                          endif /* Gould */
#                                        endif /* DEC */
#                                      endif /* Pyramid */
#                                    endif /* 386 */
#                                  endif /* 486 */
#                                endif /* 386BSD */
#                              endif /* BSDI BSD/386 */
#                            endif /* NetBSD */
#                          endif /* FreeBSD */
#                        endif /* SCO Xenix */
#                      endif /* SCO Unix */
#                    endif /* Minix */
#                  endif /* Linux */
#                endif /* NeXT */
#              endif /* Amdahl */
#            endif /* Cray */
#          endif /* RT/AIX */
#        endif /* AIX */
#      endif /* OSF/1 */
#    endif /* HP/UX */
#  endif /* Sun */
#endif /* SGI */

#if USE_DE
   " am ", __DATE__
#else /* !USE_DE */
   _(" on "), __DATE__
#endif /* !USE_DE */
   );
}
#              endif /* default: UNIX */
#            endif /* !__50SERIES */
#          endif /* !ATARI */
#        endif /* !AMIGA */
#      endif /* !ACORN */
#    endif /* !OS2 */
#  endif /* !WIN32 */
#endif /* !MSDOS */
