/*
** Datei: DVIMISC.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdarg.h>
#ifdef AMIGA
#include <proto/dos.h>
#endif
#ifdef ATARI_ST
#ifdef __TURBOC__
#include <tos.h>
#endif
#ifdef __ATARIGNU__
#include <osbind.h>
#include <aesbind.h>
#include <vdibind.h>
#endif
#endif
#include "dvi.h"
#include "dvimisc.h"
#include "dvihdcp.h"

#if defined(UNIX) || defined(AMIGA)

char *fname(char *name)
{
    char *p = strrchr(name,BSLASH);
    if (p==NULL) p = name-1;
    return p+1;
}

void slash(char *s)
{
    for ( ; *s; s++) if (*s=='\\') *s='/';
}

char *strlwr(char *s)
{
    char *r;
    for (r=s; *r; r++) if (isupper(*r)) *r=tolower(*r);
    return s;
}

#else

char *fname(char *name)
{
    char *p = strrchr(name,BSLASH);
    if (p==NULL && name[0] && name[1]==':') p = name+1;
    if (p==NULL) p = name-1;
    return p+1;
}

void slash(char *s)
{
    for ( ; *s; s++) if (*s=='/') *s='\\';
}

#endif

char *fext(char *name)
{
    char *p = strrchr(name,BSLASH), *e = strrchr(name,'.');
    if (e!=NULL && p!=NULL && p>e) e = NULL;
    return e;
}

void catpf(char *pathname, char *path, char *name)
{
    if (pathname!=path) strcpy(pathname,path);
#ifdef AMIGA
    if( DOSBase && ( DOSBase->dl_lib.lib_Version > 36 ) )
      AddPart( pathname, name, MAX_PATH_LEN - 1 );
    else
    {
      if( *pathname && ( pathname[strlen(pathname)-1] != BSLASH ) )
        strcat( pathname, BSLASHS );
      strcat( pathname, name);
    }
#else
    if (*pathname && pathname[strlen(pathname)-1]!=BSLASH)
	strcat(pathname,BSLASHS);
    strcat(pathname,name);
#endif
}

void getfile(char *filename, char *pathname)
{
    strcpy(filename,fname(pathname));
}

void catfe(char *filename, char *basename, char *extension)
{
    if (filename!=basename) strcpy(filename,basename);
    if (fext(filename)==NULL)
    {
	strcat(filename,".");
	strcat(filename,extension);
    }
    else if (fext(filename)[1]=='\0')
	strcat(filename,extension);
}

void exgext(char *new, char *old, char *extension)
{
    char *e;
    if (new!=old) strcpy(new,old);
    if ( (e=fext(new))!=NULL)
	strcpy(e+1,extension);
    else
    {
	strcat(new,".");
	strcat(new,extension);
    }
}

void exgpath(char *new, char *old, char *path)
{
    char temp[FMSIZE];
    strcpy(temp,fname(old));
    strcpy(new,path);
    catpf(new,new,temp);
}

FILE *fopene(char *name, char *mode, char *path, char *found_name)
{
    char new_name[128], new_path[128], *p;
    FILE *r;

    strcpy(new_name,name);
    r = fopen(new_name,mode);
    while(r==NULL && *path)
    {
	for(p=new_path; *path && *path!=PATH_SEP; ) *p++ = *path++;
	if (*path==PATH_SEP) path++;
	*p = '\0';
	exgpath(new_name,name,new_path);  
	r=fopen(new_name,mode);
    }
    if (found_name!=NULL) strcpy(found_name,new_name);
    return r;
}

char * fmt_page(long *p)
{
    static char string[160];
    char *s;
    int i, n=0;

    for (i=1; i<10; i++) 
	if (p[i]!=0 && p[i]!=ASTERISK) n=i;

    s=string;
    for (i=0; i<=n; i++)
    {
	if (p[i]==ASTERISK) strcpy(s,"*");
	else sprintf(s,"%ld",p[i]);
	s += strlen(s);
	if (i<n) *s++='.';
    }
    *s++='\0';
    return string;
}



#define tou(c) (islower(c) ? toupper(c) : (c))
int strcm2(const char *s, const char *t)
{
    for(;*s && *t; s++,t++)
	if (tou(*s)!=tou(*t)) break;
    return tou(*s)-tou(*t);
}

#ifdef TURN_INTS
void turn_long(char *ptr, long count)
{
    while(count)
    {
	char h = ptr[0];
	ptr[0] = ptr[3];
	ptr[3] = h;
	h = ptr[1];
	ptr[1] = ptr[2];
	ptr[2] = h;
	count--;
	ptr += 4;
    }
}

void turn_word(char *buffer, long words)
{
    char b;
    while(words--)
    {
	b = buffer[0];
	buffer[0] = buffer[1];
	buffer[1] = b;
	buffer += 2;
    }
}
#endif

