#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>

#define WAIT_ON_END 2.0

#include "dvi.h"
#include "dvilw.h"

#ifdef IBMPC
#include <dos.h>
#include <bios.h>
#include <conio.h>
  extern int  Cauxin(void);
  extern void Cauxout(int);
  extern void Cauxinit(int,int);
  extern void Cauxexit(void);
  extern int  Cauxis(void);
#else
#include <tos.h>
#include <ext.h>
#endif

#define XON  17
#define XOFF 19

#ifdef IBMPC
static int ibm_line=0;

static int is_dsr(void)
{
    return (bioscom(3,0,ibm_line)&128)!=0;
}

static int init_line(char *name,int b,int p, int s,int d)
{
    int speed;
    switch(b)
    {
	case  9600: speed=0xE0; break;
	case  4800: speed=0xC0; break;
	case  2400: speed=0xA0; break;
	case  1200: speed=0x80; break;
	case   600: speed=0x60; break;
	case   300: speed=0x40; break;
	case   150: speed=0x20; break;
	case   110: speed=0x00; break;
	default   : return 0;
    }
    switch(p)
    {
	case 'n' :
	case 'N' :
	break;
	case 'e' :
	case 'E' :
	    speed |= 0x18;
	    break;
	case 'o' :
	case 'O' :
	    speed |= 0x08;
	    break;
	default  :
	    return 0;
    }
    switch(s)
    {
	case 1 :
	    break;
	case 2 :
	    speed |= 0x04;
	    break;
	default :
	    return 0;
    }
    switch(d)
    {
	case 7 :
	    speed |= 0x02;
	    break;
	case 8 :
	    speed |= 0x03;
	    break;
	default :
	    return 0;
    }
    if (!strcmp(name,"com1:")) Cauxinit(ibm_line=0,speed);
    else if (!strcmp(name,"com2:")) Cauxinit(ibm_line=1,speed);
    else return 0;
    return 1;
}

#else /* ATARI */

static int init_line(char *name,int b,int p, int s,int d)
{
    int speed,ctr=-1,ucr,rsr=-1,tsr=-1,scr=-1;
    switch(b)
    {
	case 19200: speed=0; break;
	case  9600: speed=1; break;
	case  4800: speed=2; break;
	case  3600: speed=3; break;
	case  2400: speed=4; break;
	case  2000: speed=5; break;
	case  1800: speed=6; break;
	case  1200: speed=7; break;
	case   600: speed=8; break;
	case   300: speed=9; break;
	case   200: speed=10; break;
	case   150: speed=11; break;
	case   134: speed=12; break;
	case   110: speed=13; break;
	case    75: speed=14; break;
	case    50: speed=15; break;
	default   : return 0;
    }
    ucr = 0x80;
    switch(p)
    {
	case 'n' : 
	case 'N' :
	    break;
	case 'o' :
	case 'O' :
	    ucr |= 4;
	    break;
	case 'e' :
	case 'E' :
	    ucr |= 6;
	    break;
	default  :
	    return 0;
    }
    switch(s)
    {
	case 1 :
	    ucr |= 0x08; 
	    break;
	case 2 :
	    ucr |= 0x18;
	    break;
	case 3 :
	    ucr |= 0x10;
	    break;
	default :
	    return 0;
    }
    switch(d)
    {
	case 8 :
	    break;
	case 7 :
	    ucr |= 0x20;
	    break;
	case 6 : 
	    ucr |= 0x40;
	    break;
	case 5 :
	    ucr |= 0x60;
	    break;
	default :
	    return 0;
    }
    if (strcmp(name,"aux:")) return 0;
    Rsconf(speed,ctr,ucr,rsr,tsr,scr);
    Offgibit(~16);
    return 1;
}

static int the_dsr;
static void internal_use_only()
{
    the_dsr = (*((char*)0xFFFA01l) & 2)==0;
}

static int is_dsr(void)
{
    Supexec((long(*)())internal_use_only);
    return the_dsr;
}

static void Cauxexit(void)
{
    Ongibit(16);
}

#endif

#define STRSIZE 128

static int init_ok;
static int xoff=0;
static char laser_line[STRSIZE];
static int laser_len=0;
static clock_t next_time;

static int instr(char *s1, char *s2)
{
    int l1=(int)strlen(s1);
    int i;
    for (i=(int)strlen(s2)-l1; i-->=0; s2++)
	if (!strncmp(s1,s2,l1)) return 1;
    return 0;
}

static void flush_input(void)
{
    while(Cauxis()) Cauxin();
}

static char string[STRSIZE];
static int dial(char *number)
{
    int  i,brk=0, ret=0;

    if ( number!=NULL )
    {
	flush_input();
	Cauxout('C');
	Cauxout('R');
	Cauxout('N');
	while(*number) Cauxout(*number++);
	Cauxout('\r');
	Cauxout('\n');
    }
    for (i=0; i<STRSIZE-1 && !brk;)
    {
	int c;
	if (kbhit()) { int c=getch()&127; if (c==0x1b) brk=1; }
	if (Cauxis())
	{
	    c=Cauxin();
	    if (c==13 && i>4) break;
	    if (c==13 || c==10)
	    {
		if (strncmp(string,"VAL",3)) break;
		c=' ';
	    }
	    string[i++]=c;
	}
	if (is_dsr()) break;
    }
    string[i]='\0';
    if (brk)
    {
	print("Dial interrupted by keyboard");
    }
    else
    {
	if (is_dsr())
	{
	    ret=1;
	}
	else
	{
	    print("Dial failed. (%s)",string);
	}
    }
    return ret;
}

static void test_break(void)
{
    if (kbhit())
    {
	int c=getch();
	if ( (c&127)==0x1b )
	{
	    Cauxout(3); Cauxout(4);
	    halt("Interrupted by keyboard");
	}
    }
}

static int test_line(void)
{
    int ret=0;
    while(Cauxis())
    {
	int c=Cauxin();
	if (c=='%') ret = c;
	if (c==XON) xoff=0;
	else if (c==XOFF) xoff=1;
	else if (c==13)
	{
	    laser_len=0;
	    if (!verbose)
	    {
		if (instr("status: busy",laser_line)) continue;
		if (instr("status: waiting",laser_line)) continue;
		if (instr("status: printing",laser_line)) continue;
		if (instr("status: idle",laser_line)) continue;
	    }
	    print("%s\n",laser_line);
	}
	else
	{
	    if (c<32) continue;
	    laser_line[laser_len++]=c;
	    laser_line[laser_len]=0;
	    if (laser_len>=STRSIZE-1) laser_len--;
	}
    }
    return ret;
}

void dirinit(char *line_str)
{
    char *s, *line, line_name[80];
    clock_t wait_time;

    strcpy(line_name,line_str);
    s=strrchr(line_name,';');
    if (s!=NULL)
    {
	wait_time = (clock_t)(atof(s+1) * CLK_TCK);
	*s = 0;
    }
    else wait_time=0;
#ifdef IBMPC
    line="com1:";
    s=strchr(line_name,':');
    if (s!=NULL && s!=line_name)
    {
	if (s[-1]=='1') line="com1:";
	if (s[-1]=='2') line="com2:";
    }
    if (s!=NULL) s++;
    else s = line_name;
#else
    line = "aux:";
    s = line_name;
#endif

re_init:

    if (!init_line(line,9600,'n',1,8))
	halt("Cannot access serial port: %s", line_name);
    else
	init_ok=1;
    if (*s)
    {
	clock_t w = (clock_t) ((double)clock()+CLK_TCK/4);
	while(clock()<w);
	flush_input();
	if ( !dial( s ) )
	{
	    if ( ! strncmp( string, "VAL", 3 ) )
	    {
		flush_input();
		sleep( 5 );
		goto re_init;
	    }
	    halt("Could not connect to printer: %s",s);
	}
	else print("Connected to printer %s",s);
    }
    xoff=0;
    laser_len=0;
    *laser_line=0;
    if (get_status)
	next_time=(clock_t)((double)clock()+stat_time*CLK_TCK);
    Cauxout(4);

    if (wait_time)
    {
	Cauxout(20);
	wait_time += clock();
	while(clock()<wait_time)
	{
	    if (test_line()=='%') return;
	}
	halt("I think there is no laser printer connected");
    }
}

void dirchar(int c)
{
    while(xoff)
    {
	test_line();
	test_break();
    }
    Cauxout(c);
    if (get_status)
    {
	if (clock()>next_time)
	{
	    Cauxout(20);
	    next_time=(clock_t)((double)clock()+stat_time*CLK_TCK);
	}
    }
    test_line();
    test_break();
}

void dirprint(char *string)
{
    while(*string) dirchar(*string++);
}

void direxit(int fast)
{
    if (!fast)
    {
	clock_t wait_time = (clock_t)(WAIT_ON_END * CLK_TCK);
	while(xoff) { test_line(); test_break(); }
	Cauxout(4); Cauxout(20);
	while(xoff) { test_line(); test_break(); }
	wait_time += clock();
	while(clock()<wait_time)
	{
	    test_line();
	    test_break();
	}
    }
    if (init_ok) Cauxexit();
    init_ok=0;
}
