/*
** Datei: DVINECP6.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <stdarg.h>
#include "dvi.h"
#include "dviframe.h"
#include "dvihdcp.h"

/*
** ------------------------ Canon BJ300 (360x360) -------------------
*/

void skpl_bj300(int skip)
{
    if (skip)
    {
	while(skip>255)
	{
	    prbyte(27); prbyte('J'); prbyte(255);
	    skip -= 255;
	}
	prbyte(27); prbyte('J'); prbyte(skip);
    }
}

void init_bj300(void)
{
    /* Set Graphic Line Spacing to 1/360 inch */
    prbyte(27); prbyte(91); prbyte(92);
    prbyte(4); prbyte(0);
    prbyte(0); prbyte(0);
    prbyte(0x68); prbyte(0x01);
}

void exit_bj300(void)
{
    if (op.formfeed) prbyte(12);
}

static int send_bj300(long addr, int words, int frame_width, int pos)
{
    int i, columns, pattern;

    if (op.separate) { pattern=0xAAAA; columns=0; }
    else {pattern=0xFFFF; columns=1; }
    for (; columns<2; columns++, pattern>>=1)
    {
	if (pos/3>0)
	{
	    prbyte(27); prbyte('d');
	    prbyte( (pos/3)&255 );
	    prbyte( (pos/3)>>8  );
	}

	prbyte(27); prbyte('['); prbyte('g');
	prbyte( ((words*16+pos%3)*6+1)&255 );
	prbyte( ((words*16+pos%3)*6+1)>>8  );
	prbyte(16);

	for (i=0; i<pos%3; i++)
	{
	    prbyte(0); prbyte(0); prbyte(0);
	    prbyte(0); prbyte(0); prbyte(0);
	}
	send48(frame_ptr(addr),words,frame_width,pattern);

	prbyte(13);
    }
    return 0;
}

int bj300(void)
{
    return print_page(48,skpl_bj300,send_bj300,init_bj300,exit_bj300);
}

