/*
** Datei: DVI.H
** Autor: Ingo Eichenseher
**        Gerhard Wilhelms
**
** Aenderung: 12.11.92
*/

#ifdef IBMPC
#define TURN_INTS
#define NO_IMG
#else
#define huge
#define far
#endif

#ifndef ATARI_ST
#define PK_FULLCONFIG
#endif

#define ASTERISK        -999999l
#define MAX_PATH_LEN 128

#ifdef IBMPC
#define MISSING "missing.bat"
#else
#define MISSING "missing.fnt"
#endif

#if defined(UNIX) || defined(AMIGA)
#ifdef UNIX
#define PATH_SEP ':'
#else
#define PATH_SEP ','
#endif
#define BSLASH '/'
#define BSLASHS "/"
#define FMSIZE 128
#else
#define PATH_SEP ';'
#define BSLASH '\\'
#define BSLASHS "\\"
#define FMSIZE 64
#endif              

/*
 * M.Z., 13.09.1992
 * Von mir eingefuehrt; muss aber ( ausser Amiga ) nicht sinnvoll sein:
 * Default-Strings fuer die vollkonfigurierbaren Fontnamen/-pfade
 */
#ifdef PK_FULLCONFIG
#ifdef AMIGA
#define PK_FULLNAME "TeX:pk/%hx%v/%d/%s.%dpk"
#endif
#ifdef UNIX
#define PK_FULLNAME "./%s.%dpk:/server/local/lib/tex/pk%h/%s.%dpk"
#endif
#ifdef ATARI_ST
#define PK_FULLNAME "RES%h.SCR\\MAG%m\\%s.pk"
#endif
#ifdef IBMPC
#define PK_FULLNAME "%d\\%s.pk"
#endif
#ifndef PK_FULLNAME
#define PK_FULLNAME "%d/%s.pk"
#endif
#else
#define PK_FULLNAME ""
#endif

#if defined(__TURBOC__) || defined(__ATARIGNU__)
typedef unsigned char   byte;   /*  8 Bit unsigned */
typedef int             Sword;  /* 16 Bit signed   */
typedef unsigned int    Uword;  /* 16 Bit unsigned */
typedef long            Slong;  /* 32 Bit signed   */
typedef unsigned long   Ulong;  /* 32 Bit unsigned */
#endif

#if defined(UNIX) || defined(AMIGA)
typedef unsigned char   byte;   /*  8 Bit unsigned */
typedef short           Sword;  /* 16 Bit signed   */
typedef unsigned short  Uword;  /* 16 Bit unsigned */
typedef int             Slong;  /* 32 Bit signed   */
typedef unsigned int    Ulong;  /* 32 Bit unsigned */
#endif

#ifndef SEEK_SET
#define SEEK_SET 0      /* Absolute Filepositionierung */
#define SEEK_CUR 1      /* Relative Filepositionierung */
#define SEEK_END 2      /* Positionierung relativ zum File-Ende */
#endif

#define HASHSIZE 32     /* Muss eine Zweierpotenz sein */

/*
** Die folgenden Strukturen definieren das im ATARI-GEMDOS verwendete
** Format fuer BIT-Images
*/

typedef struct
{
    Sword   im_version;     /* Versionsnummer */
    Sword   im_headlength;  /* Laenge des Headers in Worten */
    Sword   im_nplanes;     /* Anzahl der Farbebenen */
    Sword   im_patlen;      /* Musterlaenge in Bytes */
    Sword   im_pixwidth;    /* Pixelbreite in mm/1000 */
    Sword   im_pixheight;   /* Pixelhoehe in mm/1000 */
    Sword   im_scanwidth;   /* Zeilenbreite in Pixels */
    Sword   im_nlines;      /* Anzahl der Zeilen */
} IMGHEADER;

typedef struct
{
    FILE        *img_fp;
    IMGHEADER    img_header;
    Sword        img_bytes;
    Sword        img_repeat;
    char         img_buffer[1];
} IMG_FILE;

typedef struct tfm_lengths
{
    Uword   lf; /* Length of file in 32 bit words               */
    Uword   lh; /* Length of header data                        */
    Uword   bc; /* first character code int font                */
    Uword   ec; /* last character code in font                  */
    Uword   nw; /* number of words in width table               */
    Uword   nh; /* number of words in height table              */
    Uword   nd; /* number of words in depth table               */
    Uword   ni; /* number of words in italic correction table   */
    Uword   nl; /* number of words of lig/kern program          */
    Uword   nk; /* number of words in kern table                */
    Uword   ne; /* number of words in extensible character table*/
    Uword   np; /* number of font parameters                    */
} tfm_lengths;

typedef union tfm_fix
{
    Slong   l;
    byte    b[4];
} tfm_fix;

typedef struct tfm_header
{
    Slong   check_sum;
    Slong   design_size;
    Slong   coding_scheme[10];
    Slong   font_identifier[5];
    Slong   random;
} tfm_header;

typedef struct tfm_finfo
{
    byte    width_index;
    byte    res1, res2, res3;
} tfm_finfo;

typedef struct tfm_file
{
    tfm_lengths *lengths;
    tfm_header  *header;
    tfm_finfo   *finfo;
    tfm_fix     *width;
} tfm_file;

typedef struct def_list
{
    struct def_list *next; /* Zeiger auf naechstes Element */
    long cc;               /* Character code */
} def_list;

typedef enum f_type
{
    f_pk,        /* normaler PK-Font */
    f_vf,        /* virtueller Font */
    f_ps,        /* Postscript oder residenter Font */
    f_tfm,       /* Nur TFM-File vorhanden */
    f_ref,       /* Zeiger auf bereits geladenen Font */
    f_not_found  /* unbekannter Font */
} f_type;

/*
** Die folgende Struktur beschreibt einen geladenen Zeichensatz.
** Es sind sowohl die Groesseninformationen aus dem DVI-File als
** auch die aus dem geladenen PK-File vorhanden. Die eigentlichen
** Buchstaben des Fonts sind in einer gesonderten verketteten Liste
** gespeichert, die fuer einen schnelleren Zugriff auf die ersten
** Buchstaben durch ein Array von Zeigern auf die ersten Buchstaben
** in dieser verketteten Liste ergaenzt ist.
*/

typedef struct font
{
    struct font *next; /* Fuer verkettete Liste von Fonts 	*/
    long    k;              /* Von TeX verwendete Font-Nummer   */
    long    c;              /* Checksum des Fonts               */
    long    s;              /* Fontgroesse in 2^-16 Points      */
    long    d;              /* Designgroesse in 2^-16 Points      */
    char    *n;             /* Fontname der Laenge a+l           */
    long    space;          /* Breite eines Blanks in 2^-16 P.  */
    long    design_size;    /* Designsize aus dem PK-File       */
    long    check_sum;      /* Checksum aus dem PK-File         */
    int     warn;
    f_type  typ;
    long    number;
    char    filename[MAX_PATH_LEN];
    char    *ps_name;       /* Name des residenten Fonts        */
    int     ps_num;
    unsigned int loaded:1;
    unsigned int locked:1;
    union
    {
	struct /* fuer PK-Fonts */
	{
	    long    hppp;           /* Pixels per Point *2^16 horiz.    */
	    long    vppp;           /* Pixels per Point *2^16 vertik.   */
	    struct  pk_char **hash; /* fuer schnelleren Zugriff     */
	    struct  def_list *defined;
	} pk;
	struct /* Fuer residente Fonts und TFM-Files */
	{
	    struct  tfm_file *tfm;
	} tfm;
	struct /* Fuer virtuelle Fonts */
	{
	    struct  vf_char **hash;
	    struct  font *fl;
	} vf;
    } f;
} fnt_t;

/*
** Die naechste Struktur beschreibt einen einzelnen Buchstaben aus
** einem Font, der einer verketteten Liste von Buchstaben angehoert.
*/

typedef struct pk_char
{
    struct  pk_char *next;  /*  0: Naechster Buchstabe in der Liste  */
    int     dyn_f;  /*  4: Dynamische Pack-Variable                 */
    int     state;  /*  6: Status des ersten Pixels schwarz/weiss   */
    long    pl;     /*  8: Packet-Length, also Laenge dieses Char.   */
    long    cc;     /* 12: Character-Code (vergleichbar ASCII-Code) */
    long    tfm;    /* 16: Breite des Character als "fix_word"      */
    long    dx;     /* 20: */
    long    dy;     /* 24: */
    long    w;      /* 28: Breite der Bounding Box des Character    */
    long    h;      /* 32: Hoehe der Bounding Box des Character      */
    long    hoff;   /* 36: Horizontaler Offset des Referenzpunkts   */
    long    voff;   /* 40: Vertikaler Offset des Referenzpunkts     */
    byte    data[1];/* 44: Gepackte Run-Lengths in Nibbles          */
} pk_char;

typedef struct vf_char
{
    struct  vf_char *next;  /* Naechster in der Liste    */
    long    pl;             /* Packet-Length (der DVI-Kommandos) */
    long    cc;             /* Character Code */
    long    tfm;            /* Breite des Character als "fix_word" */
    byte    data[1];        /* DVI-Kommandos */
} vf_char;

typedef struct dvi_info
{
    double  hconv;      /* Skalierungsfaktor DVI->Pixels horizontal */
    double  vconv;      /* Skalierungsfaktor DVI->Pixels vertikal */
    int     width;      /* Breite der Bitmap in Pixels */
    int     height;     /* Hoehe der Bitmap in Pixels */
    int     pages;      /* Anzahl physikalischer Seiten */
    long   *table;      /* Zeiger auf die Seitenanfaenge im DVI-File */
    fnt_t  *fonts;      /* Liste der in der postamble definierten Fonts */
    long    mag, orig;  /* Vergroesserungsfaktor im DVI-File */
    long    num, den;
    long    l, u, last;
    int     stack, valid;
} dvi_info_t;

typedef struct pos
{
    long h,v,w,x,y,z,hh,vv;
} pos;

# ifdef INT_ROUNDS
# define round(x)  (lround(x))
# define iround(x) ((int)(x))
# define lround(x) ((long)(x))
# define itrunc(x) ( (int)floor(x) )
# else
# define round(x)   (lround(x))
# define iround(x)  ((int)( (x)<0 ? (x)-0.5:(x)+0.5))
# define lround(x)  ((long)( (x)<0 ? (x)-0.5:(x)+0.5))
# define itrunc(x)  ((int)(x))
# endif

extern const int    dvilw;
/*
extern FILE        *missing;
*/

extern int      spec_char;
extern char     spec_token[];
extern int      spec_getc(void);
extern char    *spec_gettok(void);
extern void     spec_ungetc(int c);
extern char    *spec_string(int maxlen);
extern void     spec_input(char *filename);
extern void     special(long length, int x, int y);

extern void     gr_command(int x, int y);

extern char     version_string[];

extern void huge *mem_alloc(long n, char *comment);
extern void     mem_free(void huge *ptr, long n);
extern void     mem_test(void);
extern char    *mem_strdup(char *string);
extern void     mem_strfree(char *string);

extern int      resident(fnt_t *f);
extern void     fnt_select(fnt_t*);
extern int      fnt_define(fnt_t **fl, long k,long c,long s,long d, char *n);
extern void     fnt_free(fnt_t *f, int total);
extern fnt_t *fnt_find(fnt_t *fl);
extern FILE    *fnt_tfmlocate(fnt_t *f);
extern void     fnt_lfree(fnt_t *f);

extern int      stop_key(void);

extern void     dvi_fpush(FILE *fp, byte *start, byte *end);
extern int      dvi_fpost(dvi_info_t *di, long new_mag);
extern void     dvi_fpop(void);

extern int      do_page(pos *ip, fnt_t **fl, double hconv,  double vconv,
		    int virtual, long *lower, long *upper);
extern void     do_bop(long ll[10]);
extern void     do_eop(int char_missing);
extern void     do_pkchar(pk_char *c, pos *p);
extern void     do_resident_char(long cc, pos *p);
extern void     do_rule(pos *p, long width, long height);
extern void     do_font(fnt_t *f);
extern void     do_special(long len, pos *p);
extern void     end_string(void);

typedef struct
{
    long    magic;          /* Kennung beim Speichern auf File */
    long    hres;           /* Aufloesung horizontal */
    long    vres;           /* Aufloesung vertikal  */
    double  width;          /* Seitenbreite in inches */
    double  height;         /* Seitenhoehe in inches */
    double  voffset;        /* oberer Rand in inches */
    double  hoffset;        /* linker Rand in inches */
    double  vspread;        /* unterer Rand in inches */
    double  hspread;        /* rechter Rand in inches */
    double  hmargin;        /* Offset links in inches */
    double  vmargin;        /* Offset oben in inches */
    double  density;        /* Druckdichte von IMG-Grafiken */
    long    new_mag;        /* Vergroesserungsstufe */
    int     copies;         /* Anzahl Exemplare pro Seite */
    int     shipno;         /* Nummer des Ausgabegeraetes */
    int     formfeed    :1; /* Seitenvorschub nach jeder Seite */
    int     separate    :1; /* gerade/ungerade Pixels getrennt drucken */
    int     show_img    :1; /* IMG-Grafiken/Rahmen */
    int     landscape   :1; /* Seite um 90 Grad gedreht */
    int     singlesheet :1; /* Warten auf Blatteinlegen */
    int     thin_out    :1; /* Vermeiden aufeinanderfolgender Pixels */
    int     showfonts   :1; /* Anzeigen der gefundenen Fonts */
    int     dvimemory   :1; /* DVI-File im Speicher */
    int     tracemem    :1; /* Anzeige von Speicherreservierungen */
    int     autowindow  :1; /* Automatische Fensterselektion */
    int     tracechars  :1; /* Anzeige fehlender Zeichen */
    int     biosprint   :1; /* Verwendung der BIOS-Routinen */
    int     biosdev;        /* Ausgabegeraet bei BIOS-Routinen */
    long    pixmem;         /* Maximalspeicher fuer die Bitmap */
    long    maxmem;         /* Maximal zu allozierender Speicher */
    long    pathmem;        /* Maximalzahl Pixels auf Fuellpfad */
    char    redirect[MAX_PATH_LEN];
    char    log_name[MAX_PATH_LEN];
    char    dvi_path[MAX_PATH_LEN];
    char    img_path[MAX_PATH_LEN];
    char    pk_path[MAX_PATH_LEN];
#ifdef AMIGA
    char    pk_callmf[MAX_PATH_LEN]; /* Name des externen ARexx Scirpts fuer Fonts */
#endif
    char    input_path[MAX_PATH_LEN];
    char    tfm_path[MAX_PATH_LEN];
    char    vf_path[MAX_PATH_LEN];
} options;

extern options      op;
extern dvi_info_t   dvi_info;
extern FILE        *log_file;
extern long         font_maxsize;
extern double       aspect_ratio;
extern void         psfont_def(fnt_t *f, double size);

extern int      dvi_finit(char *name, char *path);
extern int      dvi_fseek(long offset);
extern int      dvi_fmove(long offset);
extern int      dvi_fgetc(void);
extern void     dvi_fexit(void);

extern IMG_FILE *img_open(char *name, int *width, int *height, int *bytes,
		   int *pix_width, int *pix_height, char *path);
extern char *img_read(char *scan_line, register IMG_FILE *img);
extern void  img_close(IMG_FILE *img);
extern int   read_img(char *name, int x, int y, double dens);
extern void  other_special(int x, int y);


extern void out_string(char *string);
extern void out_newline(void);
extern void halt(char *format, ... );
extern void vprint(char *format, va_list l);
extern void print(char *format, ... );
extern void printnnl(char *format, ...);
extern void xprint(int extra, char *format, ...);
extern void term_clean(void);
extern void fmt_stop(void);
extern void close_missing(void);

#ifdef apollo
extern char *strlwr(char *s);
extern int getch(void);
#endif
