use 5.005;
use strict;

use ExtUtils::MakeMaker;

WriteMakefile(
	NAME => 'Arch',
	DISTNAME => 'Arch',
	dist => {
		# default CP 'ln' is buggy, it changes source file permissions
		DIST_CP => 'cp',
	},
	test => {
		TESTS => 'tests/*-[1-9]',
	},
	PM => {
		map {
			my $t = $_; $t =~ s!^perllib/!!;
			($_, '$(INST_LIBDIR)/' . $t)
		} "perllib/Arch.pm", glob("perllib/Arch/*.pm")
	},
	# this translation should not be needed, but MakeMaker is buggy again
	MAN3PODS => {
		map {
			my $t = $_; $t =~ s!^perllib/!!; 
			$t =~ s!/!::!g; $t =~ s/\.pm$//;
			($_, '$(INST_MAN3DIR)/' . "$t.3pm")
		} "perllib/Arch.pm", glob("perllib/Arch/*.pm")
	},
	VERSION_FROM => 'perllib/Arch.pm',
	ABSTRACT_FROM => 'perllib/Arch.pm',
	AUTHOR => 'Mikhael Goikhman <migo@homemail.com>',
);

open MANIFEST, "<MANIFEST";
my @old_lines = grep !/^META.yml/, <MANIFEST>;
close MANIFEST;
my @new_lines = map { "$_\n" } (
	qw(
		AUTHORS
		COPYING
		Makefile.PL
		MANIFEST
		INSTALL
		NEWS
		README
		TODO
	),
	glob("doc/*"),
	"perllib/Arch.pm",
	glob("perllib/Arch/*.pm"),
	glob("tests/*-[1-9]"),
);
if (join(',', @old_lines) ne join(',', @new_lines)) {
	print "Creating MANIFEST file\n";
	open MANIFEST, ">MANIFEST" or die "Can't write MANIFEST: $!\n";
	print MANIFEST @new_lines;
	close MANIFEST;
}

sub MY::postamble {
	return <<'MAKE_FRAG';
test-network:
	@env USE_NETWORK=1 $(MAKE) test

MAKE_FRAG
}
