# Generated by default/object.tt
package Paws::Athena::Column;
  use Moose;
  has Comment => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::Column

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Athena::Column object:

  $service_obj->Method(Att1 => { Comment => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Athena::Column object:

  $result = $service_obj->Method(...);
  $result->Att1->Comment

=head1 DESCRIPTION

Contains metadata for a column in a table.

=head1 ATTRIBUTES


=head2 Comment => Str

Optional information about the column.


=head2 B<REQUIRED> Name => Str

The name of the column.


=head2 Type => Str

The data type of the column.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

