package Net::Twitter::Lite::API::V1;
{
  $Net::Twitter::Lite::API::V1::VERSION = '0.12000';
}
use warnings;
use strict;

=head1 NAME

Net::Twitter::Lite::API::V1 - Method definitions for Twitter's deprecated API v1

=head1 VERSION

version 0.12000

=cut

sub api_def () { +[
    [ Lists => [
        [ 'legacy_add_list_member', {
            aliases         => [ qw// ],
            path            => ':user/:list_id/members',
            method          => 'POST',
            params          => [ qw/user list_id id/ ],
            required        => [ qw/user list_id id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_create_list', {
            aliases         => [ qw// ],
            path            => ':user/lists',
            method          => 'POST',
            params          => [ qw/user name mode description/ ],
            required        => [ qw/user name/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_delete_list', {
            aliases         => [ qw// ],
            path            => ':user/lists/:list_id',
            method          => 'DELETE',
            params          => [ qw/user list_id/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_delete_list_member', {
            aliases         => [ qw/legacy_remove_list_member/ ],
            path            => ':user/:list_id/members',
            method          => 'DELETE',
            params          => [ qw/user list_id id/ ],
            required        => [ qw/user list_id id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_get_list', {
            aliases         => [ qw// ],
            path            => ':user/lists/:list_id',
            method          => 'GET',
            params          => [ qw/user list_id/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_get_lists', {
            aliases         => [ qw/legacy_list_lists/ ],
            path            => ':user/lists',
            method          => 'GET',
            params          => [ qw/user cursor/ ],
            required        => [ qw/user/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_is_list_member', {
            aliases         => [ qw// ],
            path            => ':user/:list_id/members/:id',
            method          => 'GET',
            params          => [ qw/user list_id id/ ],
            required        => [ qw/user list_id id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_is_list_subscriber', {
            aliases         => [ qw/legacy_is_subscribed_list/ ],
            path            => ':user/:list_id/subscribers/:id',
            method          => 'GET',
            params          => [ qw/user list_id id/ ],
            required        => [ qw/user list_id id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_list_members', {
            aliases         => [ qw// ],
            path            => ':user/:list_id/members',
            method          => 'GET',
            params          => [ qw/user list_id id cursor/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_list_memberships', {
            aliases         => [ qw// ],
            path            => ':user/lists/memberships',
            method          => 'GET',
            params          => [ qw/user cursor/ ],
            required        => [ qw/user/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_list_statuses', {
            aliases         => [ qw// ],
            path            => ':user/lists/:list_id/statuses',
            method          => 'GET',
            params          => [ qw/user list_id since_id max_id per_page page/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_list_subscribers', {
            aliases         => [ qw// ],
            path            => ':user/:list_id/subscribers',
            method          => 'GET',
            params          => [ qw/user list_id id cursor/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_list_subscriptions', {
            aliases         => [ qw// ],
            path            => ':user/lists/subscriptions',
            method          => 'GET',
            params          => [ qw/user cursor/ ],
            required        => [ qw/user/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_members_create_all', {
            aliases         => [ qw/legacy_add_list_members/ ],
            path            => ':user/:list_id/members/create_all',
            method          => 'POST',
            params          => [ qw/user list_id screen_name user_id/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_subscribe_list', {
            aliases         => [ qw// ],
            path            => ':user/:list_id/subscribers',
            method          => 'POST',
            params          => [ qw/user list_id/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_unsubscribe_list', {
            aliases         => [ qw// ],
            path            => ':user/:list_id/subscribers',
            method          => 'DELETE',
            params          => [ qw/user list_id/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
        [ 'legacy_update_list', {
            aliases         => [ qw// ],
            path            => ':user/lists/:list_id',
            method          => 'POST',
            params          => [ qw/user list_id name mode description/ ],
            required        => [ qw/user list_id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'lists_api_url',
        } ],
    ] ],
    [ REST => [
        [ 'account_settings', {
            aliases         => [ qw// ],
            path            => 'account/settings',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'account_totals', {
            aliases         => [ qw// ],
            path            => 'account/totals',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'add_list_member', {
            aliases         => [ qw// ],
            path            => 'lists/members/create',
            method          => 'POST',
            params          => [ qw/list_id slug user_id screen_name owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'add_place', {
            aliases         => [ qw// ],
            path            => 'geo/place',
            method          => 'POST',
            params          => [ qw/name contained_within token lat long attribute:street_address callback/ ],
            required        => [ qw/name contained_within token lat long/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'all_subscriptions', {
            aliases         => [ qw/all_lists list_subscriptions/ ],
            path            => 'lists/all',
            method          => 'GET',
            params          => [ qw/user_id screen_name count cursor/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'block_exists', {
            aliases         => [ qw// ],
            path            => 'blocks/exists/:id',
            method          => 'GET',
            params          => [ qw/id user_id screen_name include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'blocking', {
            aliases         => [ qw// ],
            path            => 'blocks/blocking',
            method          => 'GET',
            params          => [ qw/page include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'blocking_ids', {
            aliases         => [ qw// ],
            path            => 'blocks/blocking/ids',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'contributees', {
            aliases         => [ qw// ],
            path            => 'users/contributees',
            method          => 'GET',
            params          => [ qw/user_id screen_name include_entities skip_satus/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities skip_satus/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'contributors', {
            aliases         => [ qw// ],
            path            => 'users/contributors',
            method          => 'GET',
            params          => [ qw/user_id screen_name include_entities skip_satus/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities skip_satus/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_block', {
            aliases         => [ qw// ],
            path            => 'blocks/create/:id',
            method          => 'POST',
            params          => [ qw/id user_id screen_name include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_favorite', {
            aliases         => [ qw// ],
            path            => 'favorites/create/:id',
            method          => 'POST',
            params          => [ qw/id include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_friend', {
            aliases         => [ qw/follow_new/ ],
            path            => 'friendships/create/:id',
            method          => 'POST',
            params          => [ qw/id user_id screen_name follow include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities follow/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_list', {
            aliases         => [ qw// ],
            path            => 'lists/create',
            method          => 'POST',
            params          => [ qw/list_id slug name mode description owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'create_saved_search', {
            aliases         => [ qw// ],
            path            => 'saved_searches/create',
            method          => 'POST',
            params          => [ qw/query/ ],
            required        => [ qw/query/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'delete_list', {
            aliases         => [ qw// ],
            path            => 'lists/destroy',
            method          => 'POST',
            params          => [ qw/owner_screen_name owner_id list_id slug/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'delete_list_member', {
            aliases         => [ qw/remove_list_member/ ],
            path            => 'lists/members/destroy',
            method          => 'POST',
            params          => [ qw/list_id slug user_id screen_name owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_block', {
            aliases         => [ qw// ],
            path            => 'blocks/destroy/:id',
            method          => 'POST',
            params          => [ qw/id user_id screen_name/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_direct_message', {
            aliases         => [ qw// ],
            path            => 'direct_messages/destroy/:id',
            method          => 'POST',
            params          => [ qw/id include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_favorite', {
            aliases         => [ qw// ],
            path            => 'favorites/destroy/:id',
            method          => 'POST',
            params          => [ qw/id include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_friend', {
            aliases         => [ qw/unfollow/ ],
            path            => 'friendships/destroy/:id',
            method          => 'POST',
            params          => [ qw/id user_id screen_name include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_saved_search', {
            aliases         => [ qw// ],
            path            => 'saved_searches/destroy/:id',
            method          => 'POST',
            params          => [ qw/id/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'destroy_status', {
            aliases         => [ qw// ],
            path            => 'statuses/destroy/:id',
            method          => 'POST',
            params          => [ qw/id trim_user include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'direct_messages', {
            aliases         => [ qw// ],
            path            => 'direct_messages',
            method          => 'GET',
            params          => [ qw/since_id max_id count page include_entities/ ],
            required        => [ qw/include_entities/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'disable_notifications', {
            aliases         => [ qw// ],
            path            => 'notifications/leave/:id',
            method          => 'POST',
            params          => [ qw/id screen_name include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'downtime_schedule', {
            aliases         => [ qw// ],
            path            => 'help/downtime_schedule',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 1,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'enable_notifications', {
            aliases         => [ qw// ],
            path            => 'notifications/follow/:id',
            method          => 'POST',
            params          => [ qw/id screen_name include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'end_session', {
            aliases         => [ qw// ],
            path            => 'account/end_session',
            method          => 'POST',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'favorites', {
            aliases         => [ qw// ],
            path            => 'favorites/:id',
            method          => 'GET',
            params          => [ qw/id page include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'followers', {
            aliases         => [ qw// ],
            path            => 'statuses/followers/:id',
            method          => 'GET',
            params          => [ qw/id user_id screen_name cursor include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 1,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'followers_ids', {
            aliases         => [ qw// ],
            path            => 'followers/ids/:id',
            method          => 'GET',
            params          => [ qw/id user_id screen_name cursor/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'friends', {
            aliases         => [ qw/following/ ],
            path            => 'statuses/friends/:id',
            method          => 'GET',
            params          => [ qw/id user_id screen_name cursor include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 1,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'friends_ids', {
            aliases         => [ qw/following_ids/ ],
            path            => 'friends/ids/:id',
            method          => 'GET',
            params          => [ qw/id user_id screen_name cursor/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'friends_timeline', {
            aliases         => [ qw/following_timeline/ ],
            path            => 'statuses/friends_timeline',
            method          => 'GET',
            params          => [ qw/since_id max_id count page skip_user trim_user include_entities include_rts/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 1,
            authenticate    => 1,
            booleans        => [ qw/skip_user trim_user include_entities include_rts/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'friendship_exists', {
            aliases         => [ qw/relationship_exists follows/ ],
            path            => 'friendships/exists',
            method          => 'GET',
            params          => [ qw/user_id_a user_id_b screen_name_a screen_name_b user_a user_b/ ],
            required        => [ qw/user_a user_b/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'friendships_incoming', {
            aliases         => [ qw// ],
            path            => 'friendships/incoming',
            method          => 'GET',
            params          => [ qw/cursor/ ],
            required        => [ qw/cursor/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'friendships_outgoing', {
            aliases         => [ qw// ],
            path            => 'friendships/outgoing',
            method          => 'GET',
            params          => [ qw/cursor/ ],
            required        => [ qw/cursor/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'geo_id', {
            aliases         => [ qw// ],
            path            => 'geo/id/:id',
            method          => 'GET',
            params          => [ qw/id/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'geo_search', {
            aliases         => [ qw// ],
            path            => 'geo/search',
            method          => 'GET',
            params          => [ qw/lat long query ip granularity accuracy max_results contained_within attribute:street_address callback/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_configuration', {
            aliases         => [ qw// ],
            path            => 'help/configuration',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_languages', {
            aliases         => [ qw// ],
            path            => 'help/languages',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_list', {
            aliases         => [ qw// ],
            path            => 'lists/show',
            method          => 'GET',
            params          => [ qw/list_id slug owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_lists', {
            aliases         => [ qw/list_lists/ ],
            path            => 'lists',
            method          => 'GET',
            params          => [ qw/user_id screen_name cursor/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_privacy_policy', {
            aliases         => [ qw// ],
            path            => 'legal/privacy',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'get_tos', {
            aliases         => [ qw// ],
            path            => 'legal/tos',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'home_timeline', {
            aliases         => [ qw// ],
            path            => 'statuses/home_timeline',
            method          => 'GET',
            params          => [ qw/since_id max_id count page skip_user exclude_replies contributor_details include_rts include_entities trim_user include_my_retweet/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/skip_user exclude_replies contributor_details include_rts include_entities trim_user include_my_retweet/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'is_list_member', {
            aliases         => [ qw// ],
            path            => 'lists/members/show',
            method          => 'GET',
            params          => [ qw/owner_screen_name owner_id list_id slug user_id screen_name include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities skip_status/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'is_list_subscriber', {
            aliases         => [ qw/is_subscribed_list/ ],
            path            => 'lists/subscribers/show',
            method          => 'GET',
            params          => [ qw/owner_screen_name owner_id list_id slug user_id screen_name include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities skip_status/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'list_members', {
            aliases         => [ qw// ],
            path            => 'lists/members',
            method          => 'GET',
            params          => [ qw/list_id slug owner_screen_name owner_id cursor include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities skip_status/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'list_memberships', {
            aliases         => [ qw// ],
            path            => 'lists/memberships',
            method          => 'GET',
            params          => [ qw/user_id screen_name cursor filter_to_owned_lists/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/filter_to_owned_lists/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'list_statuses', {
            aliases         => [ qw// ],
            path            => 'lists/statuses',
            method          => 'GET',
            params          => [ qw/list_id slug owner_screen_name owner_id since_id max_id per_page page include_entities include_rts/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities include_rts/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'list_subscribers', {
            aliases         => [ qw// ],
            path            => 'lists/subscribers',
            method          => 'GET',
            params          => [ qw/list_id slug owner_screen_name owner_id cursor include_entities skip_status/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities skip_status/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'lookup_friendships', {
            aliases         => [ qw// ],
            path            => 'friendships/lookup',
            method          => 'GET',
            params          => [ qw/user_id screen_name/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'lookup_users', {
            aliases         => [ qw// ],
            path            => 'users/lookup',
            method          => 'GET',
            params          => [ qw/user_id screen_name include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'members_create_all', {
            aliases         => [ qw/add_list_members/ ],
            path            => 'lists/members/create_all',
            method          => 'POST',
            params          => [ qw/list_id slug owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'members_destroy_all', {
            aliases         => [ qw/remove_list_members/ ],
            path            => 'lists/members/destroy_all',
            method          => 'POST',
            params          => [ qw/list_id slug user_id screen_name owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'mentions', {
            aliases         => [ qw/replies/ ],
            path            => 'statuses/mentions',
            method          => 'GET',
            params          => [ qw/since_id max_id count page trim_user include_rts include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user include_rts include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'new_direct_message', {
            aliases         => [ qw// ],
            path            => 'direct_messages/new',
            method          => 'POST',
            params          => [ qw/user text screen_name user_id include_entities/ ],
            required        => [ qw/user text/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'no_retweet_ids', {
            aliases         => [ qw// ],
            path            => 'friendships/no_retweet_ids',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'public_timeline', {
            aliases         => [ qw// ],
            path            => 'statuses/public_timeline',
            method          => 'GET',
            params          => [ qw/skip_user trim_user include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/skip_user trim_user include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'rate_limit_status', {
            aliases         => [ qw// ],
            path            => 'account/rate_limit_status',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'related_results', {
            aliases         => [ qw// ],
            path            => 'related_results/show/:id',
            method          => 'GET',
            params          => [ qw/id/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'report_spam', {
            aliases         => [ qw// ],
            path            => 'report_spam',
            method          => 'POST',
            params          => [ qw/id user_id screen_name include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweet', {
            aliases         => [ qw// ],
            path            => 'statuses/retweet/:id',
            method          => 'POST',
            params          => [ qw/id include_entities trim_user/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities trim_user/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweeted_by', {
            aliases         => [ qw// ],
            path            => 'statuses/:id/retweeted_by',
            method          => 'GET',
            params          => [ qw/id count page trim_user include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities trim_user/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweeted_by_ids', {
            aliases         => [ qw// ],
            path            => 'statuses/:id/retweeted_by/ids',
            method          => 'GET',
            params          => [ qw/id count page trim_user include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities trim_user/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweeted_by_me', {
            aliases         => [ qw// ],
            path            => 'statuses/retweeted_by_me',
            method          => 'GET',
            params          => [ qw/since_id max_id count page trim_user include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweeted_by_user', {
            aliases         => [ qw// ],
            path            => 'statuses/retweeted_by_user',
            method          => 'GET',
            params          => [ qw/id user_id screen_name/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweeted_to_me', {
            aliases         => [ qw// ],
            path            => 'statuses/retweeted_to_me',
            method          => 'GET',
            params          => [ qw/since_id max_id count page/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweeted_to_user', {
            aliases         => [ qw// ],
            path            => 'statuses/retweeted_to_user',
            method          => 'GET',
            params          => [ qw/id user_id screen_name/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweets', {
            aliases         => [ qw// ],
            path            => 'statuses/retweets/:id',
            method          => 'GET',
            params          => [ qw/id count trim_user include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'retweets_of_me', {
            aliases         => [ qw/retweeted_of_me/ ],
            path            => 'statuses/retweets_of_me',
            method          => 'GET',
            params          => [ qw/since_id max_id count page trim_user include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'reverse_geocode', {
            aliases         => [ qw// ],
            path            => 'geo/reverse_geocode',
            method          => 'GET',
            params          => [ qw/lat long accuracy granularity max_results/ ],
            required        => [ qw/lat long/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'saved_searches', {
            aliases         => [ qw// ],
            path            => 'saved_searches',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'sent_direct_messages', {
            aliases         => [ qw// ],
            path            => 'direct_messages/sent',
            method          => 'GET',
            params          => [ qw/since_id max_id page count include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_direct_message', {
            aliases         => [ qw// ],
            path            => 'direct_messages/show/:id',
            method          => 'GET',
            params          => [ qw/id include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_friendship', {
            aliases         => [ qw/show_relationship/ ],
            path            => 'friendships/show',
            method          => 'GET',
            params          => [ qw/source_id source_screen_name target_id target_id_name/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_saved_search', {
            aliases         => [ qw// ],
            path            => 'saved_searches/show/:id',
            method          => 'GET',
            params          => [ qw/id/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_status', {
            aliases         => [ qw// ],
            path            => 'statuses/show/:id',
            method          => 'GET',
            params          => [ qw/id trim_user include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/trim_user include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'show_user', {
            aliases         => [ qw// ],
            path            => 'users/show/:id',
            method          => 'GET',
            params          => [ qw/id screen_name include_entities/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'similar_places', {
            aliases         => [ qw// ],
            path            => 'geo/similar_places',
            method          => 'GET',
            params          => [ qw/lat long name contained_within attribute:street_address callback/ ],
            required        => [ qw/lat long name/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'subscribe_list', {
            aliases         => [ qw// ],
            path            => 'lists/subscribers/create',
            method          => 'POST',
            params          => [ qw/owner_screen_name owner_id list_id slug/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'subscriptions', {
            aliases         => [ qw// ],
            path            => 'lists/subscriptions',
            method          => 'GET',
            params          => [ qw/user_id screen_name count cursor/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'suggestion_categories', {
            aliases         => [ qw// ],
            path            => 'users/suggestions',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'test', {
            aliases         => [ qw// ],
            path            => 'help/test',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'trends', {
            aliases         => [ qw// ],
            path            => 'trends',
            method          => 'GET',
            params          => [ qw// ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 1,
            authenticate    => 0,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'trends_available', {
            aliases         => [ qw// ],
            path            => 'trends/available',
            method          => 'GET',
            params          => [ qw/lat long/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 0,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'trends_current', {
            aliases         => [ qw// ],
            path            => 'trends/current',
            method          => 'GET',
            params          => [ qw/exclude/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 0,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'trends_daily', {
            aliases         => [ qw// ],
            path            => 'trends/daily',
            method          => 'GET',
            params          => [ qw/date exclude/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 0,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'trends_location', {
            aliases         => [ qw// ],
            path            => 'trends/:woeid',
            method          => 'GET',
            params          => [ qw/woeid/ ],
            required        => [ qw/woeid/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 0,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'trends_weekly', {
            aliases         => [ qw// ],
            path            => 'trends/weekly',
            method          => 'GET',
            params          => [ qw/date exclude/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 0,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'unsubscribe_list', {
            aliases         => [ qw// ],
            path            => 'lists/subscribers/destroy',
            method          => 'POST',
            params          => [ qw/list_id slug owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update', {
            aliases         => [ qw// ],
            path            => 'statuses/update',
            method          => 'POST',
            params          => [ qw/status lat long place_id display_coordinates in_reply_to_status_id trim_user include_entities/ ],
            required        => [ qw/status/ ],
            add_source      => 1,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/display_coordinates trim_user include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_delivery_device', {
            aliases         => [ qw// ],
            path            => 'account/update_delivery_device',
            method          => 'POST',
            params          => [ qw/device/ ],
            required        => [ qw/device/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_friendship', {
            aliases         => [ qw// ],
            path            => 'friendships/update',
            method          => 'POST',
            params          => [ qw/id user_id screen_name device retweets/ ],
            required        => [ qw/id/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/device retweets/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_list', {
            aliases         => [ qw// ],
            path            => 'lists/update',
            method          => 'POST',
            params          => [ qw/list_id slug name mode description owner_screen_name owner_id/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_location', {
            aliases         => [ qw// ],
            path            => 'account/update_location',
            method          => 'POST',
            params          => [ qw/location/ ],
            required        => [ qw/location/ ],
            add_source      => 0,
            deprecated      => 1,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile', {
            aliases         => [ qw// ],
            path            => 'account/update_profile',
            method          => 'POST',
            params          => [ qw/name email url location description include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile_background_image', {
            aliases         => [ qw// ],
            path            => 'account/update_profile_background_image',
            method          => 'POST',
            params          => [ qw/image use/ ],
            required        => [ qw/image/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/use/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile_colors', {
            aliases         => [ qw// ],
            path            => 'account/update_profile_colors',
            method          => 'POST',
            params          => [ qw/profile_background_color profile_text_color profile_link_color profile_sidebar_fill_color profile_sidebar_border_color/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_profile_image', {
            aliases         => [ qw// ],
            path            => 'account/update_profile_image',
            method          => 'POST',
            params          => [ qw/image/ ],
            required        => [ qw/image/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'update_with_media', {
            aliases         => [ qw// ],
            path            => 'statuses/update_with_media',
            method          => 'POST',
            params          => [ qw/status media[] possibly_sensitive in_reply_to_status_id lat long place_id display_coordinates/ ],
            required        => [ qw/status media/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/possibly_sensitive display_coordinates/ ],
            base_url_method => 'upload_url',
        } ],
        [ 'user_suggestions', {
            aliases         => [ qw/follow_suggestions/ ],
            path            => 'users/suggestions/:category/members',
            method          => 'GET',
            params          => [ qw/category lang/ ],
            required        => [ qw/category/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw// ],
            base_url_method => 'apiurl',
        } ],
        [ 'user_timeline', {
            aliases         => [ qw// ],
            path            => 'statuses/user_timeline/:id',
            method          => 'GET',
            params          => [ qw/id user_id screen_name since_id max_id count page skip_user trim_user include_entities include_rts/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/skip_user trim_user include_entities include_rts/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'users_search', {
            aliases         => [ qw/find_people search_users/ ],
            path            => 'users/search',
            method          => 'GET',
            params          => [ qw/q per_page page include_entities/ ],
            required        => [ qw/q/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
        [ 'verify_credentials', {
            aliases         => [ qw// ],
            path            => 'account/verify_credentials',
            method          => 'GET',
            params          => [ qw/include_entities/ ],
            required        => [ qw// ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 1,
            booleans        => [ qw/include_entities/ ],
            base_url_method => 'apiurl',
        } ],
    ] ],
    [ Search => [
        [ 'search', {
            aliases         => [ qw// ],
            path            => 'search',
            method          => 'GET',
            params          => [ qw/q callback lang locale rpp page since_id until geocode show_user result_type/ ],
            required        => [ qw/q/ ],
            add_source      => 0,
            deprecated      => 0,
            authenticate    => 0,
            booleans        => [ qw// ],
            base_url_method => 'searchapiurl',
        } ],
    ] ],
]}

1;

__END__

=for Pod::Coverage api_def

=cut
