#!/usr/bin/perl

# a Dan Heng design using lines and bezier curves of degree up to 7
# Taken from https://www.desmos.com/calculator/kfv39xrzjb

use strict;
use warnings;
use Graphics::Penplotter::GcodeXY;

# create a gcode object
my $p = new Graphics::Penplotter::GcodeXY(
            papersize => "A3",
            units     => "pt",
            warn      => 1,
            id        => "DanHeng",
            check     => 1,
        );

# landscape mode
$p->translate(0,1190);
$p->rotate(-90);

# the picture
$p->curve(219.14,562.34,223.2,520.3,277,542.2);
$p->curve(219.14,562.34,218.8,491,277,542.2);
$p->curve(242,282.6,225,274.4,199.4,265.8);
$p->curve(242,282.6,231,262.2,241,225.4);
$p->curve(242,282.6,248.4,277.8,251,273);
$p->curve(237.14,267.8,282.6,286,380,308.2,386.68,338.04);
$p->curve(386.68,338.04,425.3,360.2,440,400,460.8,412.8,476.8,427.28); # 5
$p->curve(417.74,308.6,448.4,321.88,449.8,348.4,458.14,368.06);
$p->curve(348.64,226.3,370.4,239,407.26,281.14,441.66,291.86);
$p->curve(441.66,291.86,494.6,291.32,492,284,530.94,314.6);
$p->curve(530.94,314.6,560.5,328.64,579.68,331,595.06,344.94);
$p->curve(595.06,344.94,600.8,357.4,579.6,358.8,562.54,356.4,553.4,346.4); # 5
$p->curve(553.4,346.4,549.26,346.4,544.94,344.58);
$p->curve(476.8,427.28,489.32,432.56,488.7,414.92,502.32,413.28,509.06,406.46); # 5
$p->curve(509.06,406.46,514.4,402.34,508.72,396.52,510.24,378.6,510,370);  # 5
$p->curve(510,370,507,358.2,491.04,376.5,496,386,495.3,395.52);
$p->curve(498,396,493.36,394.12,473.4,404.8,473.4,413.2);
$p->line (477.516,405.74,474.82,403.6);
$p->curve(451.8,401.96,468.8,422,465,407.74,485.74,391.46,488.6,396,492.86,390.46); # 6
$p->curve(492.86,390.46,494.52,388.48,493.66,363.4);
$p->curve(493.66,363.4,489.16,356.96,480.26,366.4,480,380);
$p->curve(482.7,380.64,471,380.24,462,387.36,460.56,395);
$p->curve(468.8,384.12,465.32,378.2,460.4,372.2,452.7,370.7);
$p->curve(486.72,425.48,494,430,499.6,435.46);
$p->curve(499.6,435.46,504.2,439,520.2,419.26,527.9,416.74);
$p->curve(527.9,416.74,539.64,406.68,537.36,416.28,531.2,393.28,529.28,377.4); # 5
$p->curve(529.28,377.4,526.6,368.12,515.4,379.88,517.8,387.44,518.06,403.6);   # 5
$p->curve(520.7,405,516.4,401.32,502,414,500,418);
$p->line (501.08,416.34,498.28,414.3);
$p->line (515.12,405.12,511.32,401.4);
$p->curve(508.94,431.34,521.2,437.8,530.4,450.8);
$p->curve(530.4,450.8,546.4,460.8,551.6,465.2);
$p->line (551.6,465.2,573.88,476.8);
$p->curve(573.88,476.8,586,479.26,576.1,451.2,559.8,451.4,570.26,460.92,542.74,435.6); # 6
$p->line (542.74,435.6,526.34,417.54);
$p->line (540,382,549.72,386.8);
$p->line (549.72,386.8,570.22,355.16);
$p->curve(534.6,416.3,541.92,395.6,550.28,392.48);
$p->curve(550.28,392.48,540.54,391.8,533.28,397.932);
$p->curve(534.6,416.3,548.56,414.76,557,418.64);
$p->curve(557,418.64,541.46,419.2,534.4,426.4);
$p->curve(524.76,443.82,521.52,458.66,522.86,476.66);
$p->curve(522.86,476.66,534.4,464.4,545.2,466.12);
$p->curve(545.2,466.12,537.4,471.4,526.68,501.2);
$p->curve(526.68,501.2,538.72,500.2,550.2,505.8);
$p->curve(550.2,505.8,535.26,505.5,526.86,508.46);
$p->curve(526.86,508.46,549.4,512.2,556,520);
$p->curve(556,520,529.48,518.4,517.2,553.6,504.8,565);
$p->curve(507.08,562.8,517.46,566.72,526,574);
$p->curve(343.32,376.92,346.72,358,344.88,345.72);
$p->curve(344.88,345.72,341.44,334.4,344.34,336.74,365.2,338.44,369.3,338.06); # 5
$p->curve(369.3,338.06,372.14,335.72,374.4,334);
$p->curve(277,542.2,232,506.6,237.8,522.4,245.4,488.8,237.2,464.8,209.52,451.06); # 6
$p->curve(209.52,451.06,223.8,451,241.12,450,245,481.1);
$p->curve(240.68,464.934,240.8,460,238.8,426.8,242.8,423);
$p->curve(242.94,436.14,242,428,243,412.4,246.6,398.72,228.4,385.2); # 5
$p->curve(228.4,385.2,245.86,389.72,255.9,403.2);
$p->curve(256,414,253.74,391.54,269,358,284.32,354.4);
$p->curve(284.32,354.4,266,372.6,266,396);
$p->curve(258.8,487.2,244.4,432,252.8,397.3,294.8,355.4,304.4,361.4); #5
$p->curve(273.3,396,287.32,377.1,308,365.2,318.2,336.6);
$p->curve(318.2,336.6,324,361.28,294.2,404.84);
$p->curve(277,542.2,244,499.8,253.2,398.4,308,400.2,333.1,384.66); # 5
$p->curve(295,436.1,306.6,409.2,342,366,368.8,370);
$p->curve(368.8,370,350.46,375.4,324.4,405.4);
$p->curve(348.72,381.4,370.8,374.94,396.1,386.46);
$p->curve(396.1,386.46,362.8,381.26,330.6,415.4);
$p->curve(373.66,366.88,373.26,374.4,371.34,379.42);
$p->curve(373.66,366.88,375.4,372.84,375.02,379.9);
$p->curve(371.88,387.9,364.5,414.7,342.5,452.12);
$p->curve(421.12,432.36,384.72,444,360.4,460.46);
$p->curve(373.4,463.2,434.28,445.26,446.3,424.2);
$p->curve(419.32,479.2,440.44,461.2,443.7,439.96);
$p->curve(437.36,457.96,447.12,450.64,446.34,454.6,451.68,438.8);
$p->line (451.68,438.8,451,449);
$p->curve(451,449,458.5,444.94,466.7,444.08);
$p->curve(430.6,500.6,444.4,480.6,453.2,449.6,474.34,451.66);
$p->curve(474,450,468,450,464,450.86);
$p->line (464,450.86,468.6,446);
$p->curve(446.84,472.6,453.2,496.4,463,477.4,472,508,465.6,472.12,499,474.4,485,447.72); # 7
$p->line (453.72,462.54,452,472);
$p->line (452,472,459.6,481.4);
$p->curve(459.6,481.4,469.48,482.26,488,458,481.12,452.8);
$p->line (453.84,474.16,460.8,466);
$p->line (477,468.9,473.3,460.6);
$p->curve(465.4,427.6,460.8,443.72,474.28,450.08);
$p->line (474.28,450.08,474.8,456.1);
$p->line (478.6,456.4,474.8,456.1);
$p->line (478.6,456.4,481.32,451.28);
$p->curve(481.32,451.28,494,440,485.52,426.5);
$p->curve(477.32,427.46,489.6,443.4,467.14,447,471.6,428.8);
$p->line (465.4,427.6,471.6,428.8);
$p->curve(493.04,429.8,477,458,502,456,502.9,473);
$p->line (502.9,473,509.4,477.2);
$p->curve(509.4,477.2,515.6,454.08,486,454,498.8,434.66);
$p->curve(379.4,326.3,370.42,329.66,362.28,337.66);
$p->curve(323.04,365.58,320,378,335.92,382.62);
$p->line (323.04,365.58,326,368.74);
$p->curve(326,368.74,328.48,367.62,334.66,367.26);
$p->curve(334.66,367.26,330.04,368.56,326.74,372.8);
$p->curve(326.74,372.8,328.4,376.4,338.74,380.48);
$p->curve(329.8,375.96,334.6,371.4,341.58,370.16);
$p->line (339.26,368.28,344.16,372.06);
$p->curve(345.4,354.84,332.72,352.96,316.04,363.24);
$p->curve(345.36,356.96,339.58,362.66,332.22,367.34);
$p->curve(323.32,373.52,316.94,377.74,307.9,382.4);
$p->curve(334,384.4,326.46,381.6,323,377.94);
$p->curve(322,390,314,387,307.4,383.4);
$p->curve(316.7,392.4,310.34,389.68,305.72,386.04);
$p->curve(383.32,416.4,389.56,422.7,398,433.68);
$p->curve(367.68,421.06,378,434,381.34,437.04);
$p->curve(370.94,418,377.72,428.48,386,436);
$p->curve(377.02,426.42,382,420.8,389.06,422.62);
$p->line (396,431.2,395.12,434.2);
$p->line (364.4,414,363,420);
$p->curve(363,420,366.4,426.4,378.26,437.74);
$p->curve(357.26,424.92,361.4,434.9,366.54,441.8);
$p->curve(354.94,429.44,358.68,438,363.16,443.2);
$p->line (370.44,410.2,367.5,409);
$p->curve(257.4,536.6,266.88,570.92,274.9,560.4,287,574.86);
$p->curve(349.2,479,412.4,469.4,444.2,517.8);
$p->curve(434.5,505.19,454.8,500.26,479.4,477,500,478.2);
$p->curve(500,478.2,487.48,483.7,473.2,493.8,464.24,505.28);
$p->curve(464.24,505.28,492,500,505.6,490.6);
$p->curve(505.6,490.6,481.8,526.6,446,530);
$p->curve(446,530,476.4,534.8,491.4,531.3);
$p->curve(491.4,531.3,464,550.8,440.2,555);
$p->curve(377.2,515.6,417.7,517.7,453.6,574.8);
$p->curve(419.8,552.8,405.8,558.8,390.4,560);
$p->curve(404,552,386.8,534.2,350.4,524.4);
$p->curve(461.6,375.2,446.3,345.2,471,295.8,513.6,291.4,570,319,554.4,375,532,392); # 6
$p->line (482,397.66,485.4,400.12);
$p->line (512.86,402.92,517.9,400.5);

# the result
$p->output("bezier-danheng.gcode");

