package Google::Ads::AdWords::v201302::Feed;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201302' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %id_of :ATTR(:get<id>);
my %name_of :ATTR(:get<name>);
my %attributes_of :ATTR(:get<attributes>);
my %status_of :ATTR(:get<status>);
my %origin_of :ATTR(:get<origin>);

__PACKAGE__->_factory(
    [ qw(        id
        name
        attributes
        status
        origin

    ) ],
    {
        'id' => \%id_of,
        'name' => \%name_of,
        'attributes' => \%attributes_of,
        'status' => \%status_of,
        'origin' => \%origin_of,
    },
    {
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'attributes' => 'Google::Ads::AdWords::v201302::FeedAttribute',
        'status' => 'Google::Ads::AdWords::v201302::Feed::Status',
        'origin' => 'Google::Ads::AdWords::v201302::Feed::Origin',
    },
    {

        'id' => 'id',
        'name' => 'name',
        'attributes' => 'attributes',
        'status' => 'status',
        'origin' => 'origin',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201302::Feed

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Feed from the namespace https://adwords.google.com/api/adwords/cm/v201302.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * id


=item * name


=item * attributes


=item * status


=item * origin




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

