/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.util.StringUtil;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumHTMLRunnerResultsHandler
implements HttpHandler {
    HttpContext context;
    List<HTMLResultsListener> listeners = new Vector<HTMLResultsListener>();
    boolean started = false;

    public void addListener(HTMLResultsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse res) throws HttpException, IOException {
        if (!"/postResults".equals(pathInContext)) {
            return;
        }
        request.setHandled(true);
        String result = request.getParameter("result");
        if (result == null) {
            res.getOutputStream().write("No result was specified!".getBytes());
        }
        String seleniumVersion = request.getParameter("selenium.version");
        String seleniumRevision = request.getParameter("selenium.revision");
        String totalTime = request.getParameter("totalTime");
        String numTestPasses = request.getParameter("numTestPasses");
        String numTestFailures = request.getParameter("numTestFailures");
        String numCommandPasses = request.getParameter("numCommandPasses");
        String numCommandFailures = request.getParameter("numCommandFailures");
        String numCommandErrors = request.getParameter("numCommandErrors");
        String suite = request.getParameter("suite");
        int numTotalTests = Integer.parseInt(numTestPasses) + Integer.parseInt(numTestFailures);
        List<String> testTables = this.createTestTables(request, numTotalTests);
        HTMLTestResults results = new HTMLTestResults(seleniumVersion, seleniumRevision, result, totalTime, numTestPasses, numTestFailures, numCommandPasses, numCommandFailures, numCommandErrors, suite, testTables);
        Iterator<HTMLResultsListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            HTMLResultsListener listener = i.next();
            listener.processResults(results);
            i.remove();
        }
        this.processResults(results, res);
    }

    private void processResults(HTMLTestResults results, HttpResponse res) throws IOException {
        res.setContentType("text/html");
        OutputStream out = res.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out, StringUtil.__ISO_8859_1);
        results.write(writer);
        ((Writer)writer).flush();
    }

    private List<String> createTestTables(HttpRequest request, int numTotalTests) {
        LinkedList<String> testTables = new LinkedList<String>();
        for (int i = 1; i <= numTotalTests; ++i) {
            String testTable = request.getParameter("testTable." + i);
            testTables.add(testTable);
        }
        return testTables;
    }

    @Override
    public String getName() {
        return SeleniumHTMLRunnerResultsHandler.class.getName();
    }

    @Override
    public HttpContext getHttpContext() {
        return this.context;
    }

    @Override
    public void initialize(HttpContext c) {
        this.context = c;
    }

    @Override
    public void start() throws Exception {
        this.started = true;
    }

    @Override
    public void stop() throws InterruptedException {
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }
}

