# Copyrights 2011-2015 by [Mark Overmeer].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.01.
use warnings;
use strict;

package POSIX::1003::OS;
use vars '$VERSION';
$VERSION = '0.99_05';

use base 'POSIX::1003::Module';

my @constants;
my @functions = qw/uname/;

our %EXPORT_TAGS =
 ( constants => \@constants
 , functions => \@functions
 , tables    => [ '%osconsts' ]
 );

my  $osconsts;
our %osconsts;

BEGIN {
    $osconsts = osconsts_table;
    push @constants, keys %$osconsts;
    tie %osconsts, 'POSIX::1003::ReadOnlyTable', $osconsts;
}


sub _create_constant($)
{   my ($class, $name) = @_;
    my $val = $osconsts->{$name};
    sub () {$val};
}

1;
