#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/factorial subfactorial fubini
                         falling_factorial rising_factorial/;
use Math::BigInt try => "GMP,Pari";
my $extra = defined $ENV{EXTENDED_TESTING} && $ENV{EXTENDED_TESTING};

plan tests => 5;

subtest 'factorial', sub {
  ok(!defined eval { factorial(-5); }, "factorial(-5) gives error");

  is_deeply([map { "".factorial($_) } 0..100],
            [map { Math::BigInt->new($_)->bfac->bstr } 0..100],
            "factorial(0..100) matched Math::BigInt");
};

subtest 'subfactorial', sub {
  ok(!defined eval { subfactorial(-5); }, "subfactorial(-5) gives error");
  is_deeply( [ map { "".subfactorial($_) } 0..23 ],
             [qw/1 0 1 2 9 44 265 1854 14833 133496 1334961 14684570 176214841 2290792932 32071101049 481066515734 7697064251745 130850092279664 2355301661033953 44750731559645106 895014631192902121 18795307255050944540 413496759611120779881 9510425471055777937262/],
             "subfactoral(n) for 0..23" );
  is("".subfactorial(110), "5842828822584214646127804296800556812003401310647230252823417994828330749128488139372248218138294820842482275906806317309680576864190217329860297083368061950972635498019334565561", "subfactorial(110)");
};

my @fubini = qw/1 1 3 13 75 541 4683 47293 545835 7087261 102247563 1622632573 28091567595 526858348381 10641342970443 230283190977853 5315654681981355 130370767029135901 3385534663256845323 92801587319328411133 2677687796244384203115 81124824998504073881821 2574844419803190384544203 85438451336745709294580413/;
my $nfubini = $extra ? 23 : 19;
is_deeply( [ map { "".fubini($_) } 0..$nfubini ],
           [@fubini[0..$nfubini]],
           "fubini(n) for 0..$nfubini" );

subtest 'falling_factorial', sub {
  my $k;
  is_deeply( [map { $k=$_; map { "".falling_factorial($_,$k) } -10..10 } 0..10],
             [qw/1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -10 -9 -8 -7 -6 -5 -4 -3 -2 -1 0 1 2 3 4 5 6 7 8 9 10 110 90 72 56 42 30 20 12 6 2 0 0 2 6 12 20 30 42 56 72 90 -1320 -990 -720 -504 -336 -210 -120 -60 -24 -6 0 0 0 6 24 60 120 210 336 504 720 17160 11880 7920 5040 3024 1680 840 360 120 24 0 0 0 0 24 120 360 840 1680 3024 5040 -240240 -154440 -95040 -55440 -30240 -15120 -6720 -2520 -720 -120 0 0 0 0 0 120 720 2520 6720 15120 30240 3603600 2162160 1235520 665280 332640 151200 60480 20160 5040 720 0 0 0 0 0 0 720 5040 20160 60480 151200 -57657600 -32432400 -17297280 -8648640 -3991680 -1663200 -604800 -181440 -40320 -5040 0 0 0 0 0 0 0 5040 40320 181440 604800 980179200 518918400 259459200 121080960 51891840 19958400 6652800 1814400 362880 40320 0 0 0 0 0 0 0 0 40320 362880 1814400 -17643225600 -8821612800 -4151347200 -1816214400 -726485760 -259459200 -79833600 -19958400 -3628800 -362880 0 0 0 0 0 0 0 0 0 362880 3628800 335221286400 158789030400 70572902400 29059430400 10897286400 3632428800 1037836800 239500800 39916800 3628800 0 0 0 0 0 0 0 0 0 0 3628800/],
             "falling_factorial(-10..10, 0..10)" );
  is_deeply( [map { "".falling_factorial($_->[0],$_->[1]) } ([515,7],[516,7],[568,7],[89,10],[103,101],["36893488147419103233",2])],
             [qw/9222879462222182400 9349716704335257600 18378924259448108160 18452514066426316800 49514503582430902037733576272908866745450829110572462415026402773499383329208111416070720536941769246326758192988646046611441067207574945792000000000000000000000000 1361129467683753853890391917874491949056/],
             "falling_factorial selected values");
};

subtest 'rising_factorial', sub {
  my $k;
  is_deeply( [map { $k=$_; map { "".rising_factorial($_,$k) } -10..10 } 0..10],
             [qw/1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -10 -9 -8 -7 -6 -5 -4 -3 -2 -1 0 1 2 3 4 5 6 7 8 9 10 90 72 56 42 30 20 12 6 2 0 0 2 6 12 20 30 42 56 72 90 110 -720 -504 -336 -210 -120 -60 -24 -6 0 0 0 6 24 60 120 210 336 504 720 990 1320 5040 3024 1680 840 360 120 24 0 0 0 0 24 120 360 840 1680 3024 5040 7920 11880 17160 -30240 -15120 -6720 -2520 -720 -120 0 0 0 0 0 120 720 2520 6720 15120 30240 55440 95040 154440 240240 151200 60480 20160 5040 720 0 0 0 0 0 0 720 5040 20160 60480 151200 332640 665280 1235520 2162160 3603600 -604800 -181440 -40320 -5040 0 0 0 0 0 0 0 5040 40320 181440 604800 1663200 3991680 8648640 17297280 32432400 57657600 1814400 362880 40320 0 0 0 0 0 0 0 0 40320 362880 1814400 6652800 19958400 51891840 121080960 259459200 518918400 980179200 -3628800 -362880 0 0 0 0 0 0 0 0 0 362880 3628800 19958400 79833600 259459200 726485760 1816214400 4151347200 8821612800 17643225600 3628800 0 0 0 0 0 0 0 0 0 0 3628800 39916800 239500800 1037836800 3632428800 10897286400 29059430400 70572902400 158789030400 335221286400/],
             "rising_factorial(-10..10, 0..10)" );
  is_deeply( [map { "".rising_factorial($_->[0],$_->[1]) } ([509,7],[510,7],[562,7],[80,10],[103,101])],
             [qw/9222879462222182400 9349716704335257600 18378924259448108160 18452514066426316800 6760937240727169751346751449031021029092236987417146776093364751481076175432048515956305908925637116481562056123160956910787676051553407749205364947724300581490631820332063331242347041889126973440000000000000000000000000/],
             "rising_factorial selected values");
};
