# Generated by default/object.tt
package Paws::SSM::DocumentReviewCommentSource;
  use Moose;
  has Content => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::DocumentReviewCommentSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::DocumentReviewCommentSource object:

  $service_obj->Method(Att1 => { Content => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::DocumentReviewCommentSource object:

  $result = $service_obj->Method(...);
  $result->Att1->Content

=head1 DESCRIPTION

Information about comments added to a document review request.

=head1 ATTRIBUTES


=head2 Content => Str

The content of a comment entered by a user who requests a review of a
new document version, or who reviews the new version.


=head2 Type => Str

The type of information added to a review request. Currently, only the
value C<Comment> is supported.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

