package App::dufolder ;  
our $VERSION = '0.031' ; 
our $DATE = '2022-04-26T13:02+09:00' ; 

=encoding utf8

=head1 NAME

App::dufolder -- 指定ディレクトリのディスク使用量を算出する。見えるファイルによるサイズとと見えないファイルも含めたサイズの比も算出する。個数も算出する。Gitのコミットメッセージに使える。


=head1 SYNOPSIS

This module provides a Unix-like command `F<dufolder>'. 

=head1 DESCRIPTION

  dufolder DIR [DIR2] [DIR3] ..
  
 機能: 

  指定したフォルダ(ディレクトリ)に対して、ディスク使用量とそのフォルダ内で辿れるファイルの
   サイズのそれぞれ合計（共にバイト単位）などを標準出力に出力する。

  出力する値は、そのディレクトリからfindで辿れるファイル(ディレクトリも含む)全てと、それらの内ドットファイル以外の
   両者について、ディスク使用量(占有量)のバイト単位のサイズと、ファイルの個数を出力する。

  コマンドオプションにより、その出力をコミットメッセージにした Git のコミットに残すこともできる。

  引数の DIR が指定されない場合は、カレントディレクトリ(つまり".")が指定されたものと見なされる。

 利用例: 
    $0 -G1 .  # Gitレポジトリ内についての、ディスク占有の状況を調べて、Gitに情報をコミットメッセージに入れて、空コミットをする。
    $0 -B8 -b512 -.  # カレントディレクトリ内の、全てのファイルのディスク占有状況を表示する。

 オプション: 

    -, 0 : 千進法の3桁区切りのコンマを打たない。
    -b 512 : 各ファイルの占有するブロックサイズを取得して、それを何倍にすることで占有サイズと見なすかの、倍率。
    -i 0 : ファイルのリンクによる重複を考慮しない。つまり、両方とも数える。i-node で判定。
    -l 0 : シンボリックリンクファイルについてたどって調べる。

    -G N: Gitのコミットのメッセージ(N=0,1,2) 以下を参照せよ。     
     -G 0 : 単に gitのコマンド文を出力する。そのgit文は、--allow-empty を使う。
     -G 1 : HEAD~とHEADの間の変更が、このプログラムで実行されてる可能性が高い場合は、そのgit文は実行しないようにする。
     -G 2 : その gitのコマンド文を実行する。(cronで実行すると、どんどんコミットが増えるので、やらない方が良い。) 
    ※ -G 01 や -G02 など、0と1と2の複数を使ったオプション指定の仕方もできる。

   (ファイルシステム等に依存して 記憶媒体のクラスタとセクタのバイト数を調べるための オプション)
    -B 8 : 各ファイルがディスク上で持つブロックのバイト数の考察用。計算機環境により8以外の正の数になるかも。
    ※ 出力表のBlocksの列が、どの数の倍数か(たとえば8の倍数であるか)をまず最初に観察し、その数を次に指定すると良いだろう。
    ※ 出力表の 各行において Occ. の列が、Sizeよりも大きくなれば -b(小文字)の指定は合っている。
      その時に-bで指定する数は、S/B(1)とS/B(2)の間の数になるはず。ここで(1)は下限、(2)は上限を意味する。

    -.   : -B と共に用いる。ドットファイルについての分も表示する。

    --help : このコマンドのヘルプ(つまり、ここに現れる文面)を出力して、終了。

 作成した目的: 
  
  データファイルを蓄えていくＧｉｔのレポジトリの、ディスク占有サイズのバイト数を、
  ワークツリー内の指定フォルダー内のファイルサイズの合計バイト数、および、
  その合計値に対する占有サイズの倍率と共に記録する。
  このことで、必要なディスクサイズの成長を見積もる。

　開発メモ: 
    * このプログラムは、UNIX/Linuxコマンドのfindの動作に依存している。
    * 空コミットと直前コミット文の正規表現による条件チェックをしている。cronによる実行をしても、似たGitのコメントが多数作られないようにするため。
    * 機微な情報が含まれる可能性を考え、対象としたディレクトリの名前は出さないことにした。ファイルの個数の情報で十分なことが多いであろう。
    * デバッグ又はテストをする際に、-i と -l の相互作用で、無用に頭を悩まさせるかも知れない。

=head1 AUTHOR

下野寿之 Toshiyuki SHIMONO <bin4tsv@gmail.com> 統計数理研究所 外来研究員

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2022 Toshiyuki SHIMONO. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut

1 ;
