/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.value.DecimalValue;

public class CompilerInfo
implements Serializable {
    private transient URIResolver uriResolver;
    private transient OutputURIResolver outputURIResolver = StandardOutputResolver.getInstance();
    private transient ErrorListener errorListener;
    private CodeInjector codeInjector;
    private int recoveryPolicy = 1;
    private boolean schemaAware;
    private boolean versionWarning;
    private String messageReceiverClassName = "net.sf.saxon.serialize.MessageEmitter";
    private StructuredQName defaultInitialMode;
    private StructuredQName defaultInitialTemplate;
    private DecimalValue xsltVersion = DecimalValue.ZERO;
    private FunctionLibrary extensionFunctionLibrary;

    public CompilerInfo() {
    }

    public CompilerInfo(CompilerInfo info) {
        this.uriResolver = info.uriResolver;
        this.outputURIResolver = info.outputURIResolver;
        this.errorListener = info.errorListener;
        this.codeInjector = info.codeInjector;
        this.recoveryPolicy = info.recoveryPolicy;
        this.schemaAware = info.schemaAware;
        this.versionWarning = info.versionWarning;
        this.messageReceiverClassName = info.messageReceiverClassName;
        this.defaultInitialMode = info.defaultInitialMode;
        this.defaultInitialTemplate = info.defaultInitialTemplate;
        this.xsltVersion = info.xsltVersion;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public String getMessageReceiverClassName() {
        return this.messageReceiverClassName;
    }

    public void setMessageReceiverClassName(String messageReceiverClassName) {
        this.messageReceiverClassName = messageReceiverClassName;
    }

    public void setCodeInjector(CodeInjector injector) {
        this.codeInjector = injector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public boolean isCompileWithTracing() {
        return this.codeInjector != null;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public boolean isVersionWarning() {
        return this.versionWarning;
    }

    public void setVersionWarning(boolean warn) {
        this.versionWarning = warn;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.schemaAware = schemaAware;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    public void setDefaultInitialTemplate(StructuredQName initialTemplate) {
        this.defaultInitialTemplate = initialTemplate;
    }

    public StructuredQName getDefaultInitialTemplate() {
        return this.defaultInitialTemplate;
    }

    public void setDefaultInitialMode(StructuredQName initialMode) {
        this.defaultInitialMode = initialMode;
    }

    public StructuredQName getDefaultInitialMode() {
        return this.defaultInitialMode;
    }

    public void setXsltVersion(DecimalValue version) {
        if (!(version.equals(DecimalValue.TWO) || version.equals(DecimalValue.THREE) || version.equals(DecimalValue.ZERO))) {
            throw new IllegalArgumentException("XSLT version must be 0.0, 2.0 or 3.0");
        }
        this.xsltVersion = version;
    }

    public DecimalValue getXsltVersion() {
        return this.xsltVersion;
    }

    public void setExtensionFunctionLibrary(FunctionLibrary library) {
        this.extensionFunctionLibrary = library;
    }

    public FunctionLibrary getExtensionFunctionLibrary() {
        return this.extensionFunctionLibrary;
    }
}

